/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.beans;

import javafx.beans.property.SimpleDoubleProperty;

public class ClampedDoubleProperty
extends SimpleDoubleProperty {
    private final double minValue;
    private final double maxValue;

    public ClampedDoubleProperty(Object bean, String name, double initialValue, double minValue, double maxValue) {
        super(bean, name, initialValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void set(double newValue) {
        super.set(Math.max(this.minValue, Math.min(newValue, this.maxValue)));
    }

    public double get() {
        return Math.max(this.minValue, Math.min(super.get(), this.maxValue));
    }
}

