/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.binding;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.util.StringConverter;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxbase.binding.ListToSetTransformContentBinding;
import org.jhotdraw8.fxbase.binding.ListTransformContentBinding;
import org.jhotdraw8.fxbase.binding.MessageStringFormatter;
import org.jhotdraw8.fxbase.binding.StrongBidirectionalBinding;

public class CustomBinding {
    private CustomBinding() {
    }

    public static <T, M> void bindBidirectionalStrongly(final @NonNull Property<T> propertyA, @NonNull Property<M> mediator, final @NonNull Function<M, Property<T>> propertyB) {
        ChangeListener changeListener = new ChangeListener<M>(){
            private Property<T> strongReference;

            public void changed(ObservableValue<? extends M> o, M oldv, M newv) {
                if (oldv != null && this.strongReference != null) {
                    propertyA.unbindBidirectional(this.strongReference);
                    this.strongReference = null;
                }
                if (newv != null) {
                    this.strongReference = (Property)propertyB.apply(newv);
                    propertyA.bindBidirectional(this.strongReference);
                }
            }
        };
        changeListener.changed(mediator, null, mediator.getValue());
        mediator.addListener(changeListener);
    }

    public static <T, M> void bindBidirectionalStrongly2(final @NonNull Property<T> propertyA, @NonNull Property<M> mediator, final @NonNull Function<M, Property<T>> propertyB) {
        ChangeListener changeListener = new ChangeListener<M>(){
            private Property<T> strongReference;

            public void changed(ObservableValue<? extends M> o, M oldv, M newv) {
                if (oldv != null && this.strongReference != null) {
                    StrongBidirectionalBinding.unbind(propertyA, this.strongReference);
                    this.strongReference = null;
                }
                if (newv != null) {
                    this.strongReference = (Property)propertyB.apply(newv);
                    StrongBidirectionalBinding.bind(propertyA, this.strongReference);
                }
            }
        };
        changeListener.changed(mediator, null, mediator.getValue());
        mediator.addListener(changeListener);
    }

    public static <T, M> void bindBidirectional(@NonNull Property<T> propertyA, @NonNull Property<M> mediator, @NonNull Function<M, Property<T>> propertyB) {
        ChangeListener changeListener = (o, oldv, newv) -> {
            if (oldv != null) {
                propertyA.unbindBidirectional((Property)propertyB.apply(oldv));
            }
            if (newv != null) {
                propertyA.bindBidirectional((Property)propertyB.apply(newv));
            }
        };
        changeListener.changed(mediator, null, mediator.getValue());
        mediator.addListener(changeListener);
    }

    public static <T, M> void bind(@NonNull Property<T> propertyA, @NonNull Property<M> mediatorB, @NonNull Function<M, ObservableValue<T>> propertyB) {
        CustomBinding.bind(propertyA, mediatorB, propertyB, propertyA.getValue());
    }

    public static <T, M> void bind(@NonNull Property<T> propertyA, @NonNull Property<M> mediatorB, @NonNull Function<M, ObservableValue<T>> propertyB, T unboundValue) {
        ChangeListener changeListener = (o, oldv, newv) -> {
            if (oldv != null) {
                propertyA.unbind();
                propertyA.setValue(unboundValue);
            }
            if (newv != null) {
                propertyA.bind((ObservableValue)propertyB.apply(newv));
            }
        };
        changeListener.changed(mediatorB, null, mediatorB.getValue());
        mediatorB.addListener(changeListener);
    }

    public static <T, M> void bind(@NonNull ObservableValue<M> mediatorA, @NonNull Function<M, Property<T>> propertyA, @NonNull ObservableValue<T> propertyB, T unboundValue) {
        ChangeListener changeListener = (o, oldv, newv) -> {
            if (oldv != null) {
                Property mediatedA = (Property)propertyA.apply(oldv);
                mediatedA.unbind();
                mediatedA.setValue(unboundValue);
            }
            if (newv != null) {
                ((Property)propertyA.apply(newv)).bind(propertyB);
            }
        };
        changeListener.changed(mediatorA, null, mediatorA.getValue());
        mediatorA.addListener(changeListener);
    }

    public static <T, S> void bindBidirectional(@NonNull StringProperty propertyA, @NonNull Property<S> mediator, @NonNull Function<S, Property<T>> propertyB, @NonNull StringConverter<T> stringConverter) {
        ChangeListener changeListener = (o, oldv, newv) -> {
            if (oldv != null) {
                propertyA.unbindBidirectional(propertyB.apply(oldv));
            }
            if (newv != null) {
                propertyA.bindBidirectional((Property)propertyB.apply(newv), stringConverter);
            }
        };
        changeListener.changed(mediator, null, null);
        mediator.addListener(changeListener);
    }

    public static <A, B, PROPERTY_A extends WritableValue<A> & ObservableValue<A>, PROPERTY_B extends WritableValue<B> & ObservableValue<B>> void bindBidirectionalAndConvert(@NonNull PROPERTY_A propertyA, @NonNull PROPERTY_B propertyB, @NonNull Function<A, B> convertAtoB, @NonNull Function<B, A> convertBtoA) {
        boolean[] alreadyCalled = new boolean[1];
        propertyB.setValue(convertAtoB.apply(propertyA.getValue()));
        CustomBinding.addFlaggedChangeListener(propertyB, (ObservableValue<A>)propertyA, convertAtoB, alreadyCalled);
        CustomBinding.addFlaggedChangeListener(propertyA, (ObservableValue<B>)propertyB, convertBtoA, alreadyCalled);
    }

    private static <Y, X> void addFlaggedChangeListener(@NonNull WritableValue<X> propertyX, @NonNull ObservableValue<Y> propertyY, @NonNull Function<Y, X> updateX, boolean[] alreadyCalled) {
        propertyY.addListener((observable, oldValue, newValue) -> {
            if (!alreadyCalled[0]) {
                try {
                    alreadyCalled[0] = true;
                    propertyX.setValue(updateX.apply(newValue));
                }
                finally {
                    alreadyCalled[0] = false;
                }
            }
        });
    }

    public static @NonNull StringExpression formatted(String format, Object ... args) {
        return MessageStringFormatter.format(format, args);
    }

    public static <D, S> void bindContent(@NonNull ObservableList<D> dest, @NonNull ObservableList<S> src, @NonNull Function<S, D> toDest) {
        CustomBinding.bindContent(dest, src, toDest, null);
    }

    public static <D, S> void bindContent(@NonNull ObservableList<D> dest, @NonNull ObservableList<S> src, @NonNull Function<S, D> toDest, @Nullable Consumer<D> destOnRemove) {
        ListTransformContentBinding<D, S> binding = new ListTransformContentBinding<D, S>(dest, src, toDest, null, destOnRemove, null);
        src.addListener(binding.getSourceChangeListener());
    }

    public static <D, S> void bindContentBidirectional(@NonNull ObservableList<D> dest, @NonNull ObservableList<S> src, @NonNull Function<S, D> toDest, @Nullable Consumer<D> destOnRemove, @NonNull Function<D, S> toSource, @Nullable Consumer<S> sourceOnRemove) {
        ListTransformContentBinding<D, S> binding = new ListTransformContentBinding<D, S>(dest, src, toDest, toSource, destOnRemove, sourceOnRemove);
        src.addListener(binding.getSourceChangeListener());
        dest.addListener(binding.getDestChangeListener());
    }

    public static <D, S> void bindListContentToSet(ObservableList<D> dest, ObservableSet<S> src, Function<S, D> toDest) {
        ListToSetTransformContentBinding<D, S> binding = new ListToSetTransformContentBinding<D, S>(dest, src, toDest);
        src.addListener(binding);
    }

    public static <D, S> void bindListContentToSet(ObservableList<D> dest, ObservableSet<S> src, Function<S, D> toDest, Consumer<D> disposeDest) {
        ListToSetTransformContentBinding<D, S> binding = new ListToSetTransformContentBinding<D, S>(dest, src, toDest, disposeDest);
        src.addListener(binding);
    }

    public static <D, S> void unbindListContentToSet(ObservableList<D> dest, ObservableSet<S> src) {
        ListToSetTransformContentBinding<D, S> binding = new ListToSetTransformContentBinding<D, S>(dest, src, null);
        src.removeListener(binding);
    }

    public static <E, T> void bindElements(ObservableList<E> list, Function<E, Property<T>> getter, Property<T> property) {
        CustomBinding.bindElements(list, getter, property, null);
    }

    public static <E, T> void bindElements(ObservableList<E> list, Function<E, Property<T>> getter, Property<T> property, T unboundValue) {
        for (Object elem : list) {
            Property p = getter.apply(elem);
            p.unbind();
            p.bind(property);
        }
        list.addListener(change -> {
            while (change.next()) {
                Property p;
                for (Object removed : change.getRemoved()) {
                    p = (Property)getter.apply(removed);
                    p.unbind();
                    p.setValue(unboundValue);
                }
                for (Object added : change.getAddedSubList()) {
                    p = (Property)getter.apply(added);
                    p.unbind();
                    p.bind((ObservableValue)property);
                }
            }
        });
    }

    public static <E, T> void bindElements(ObservableList<E> list, Function<E, Property<T>> getter, Binding<T> binding) {
        CustomBinding.bindElements(list, getter, binding, null);
    }

    public static <E, T> void bindElements(ObservableList<E> list, Function<E, Property<T>> getter, Binding<T> binding, T unboundValue) {
        for (Object elem : list) {
            Property p = getter.apply(elem);
            p.unbind();
            p.bind(binding);
        }
        list.addListener(change -> {
            while (change.next()) {
                Property p;
                for (Object removed : change.getRemoved()) {
                    p = (Property)getter.apply(removed);
                    p.unbind();
                    p.setValue(unboundValue);
                }
                for (Object added : change.getAddedSubList()) {
                    p = (Property)getter.apply(added);
                    p.unbind();
                    p.bind((ObservableValue)binding);
                }
            }
        });
    }

    public static <E, T> void bindElements(ObservableList<E> list, BiConsumer<E, T> setter, T value) {
        for (Object elem : list) {
            setter.accept(elem, value);
        }
        list.addListener(change -> {
            while (change.next()) {
                for (Object removed : change.getRemoved()) {
                    setter.accept(removed, null);
                }
                for (Object added : change.getAddedSubList()) {
                    setter.accept(added, value);
                }
            }
        });
    }

    public static <E> void bindMembershipToBoolean(ObservableSet<E> set, E element, ObservableValue<Boolean> value) {
        ChangeListener changeListener = (o, oldv, newv) -> {
            if (newv.booleanValue()) {
                set.add(element);
            } else {
                set.remove(element);
            }
        };
        value.addListener(changeListener);
        changeListener.changed(value, (Object)((Boolean)value.getValue() == false ? 1 : 0), (Object)((Boolean)value.getValue()));
    }

    public static DoubleBinding computeDouble(final DoubleSupplier op, final ObservableValue<?> ... dependendies) {
        return new DoubleBinding(){
            {
                super.bind((Observable[])dependendies);
            }

            protected double computeValue() {
                return op.getAsDouble();
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.observableArrayList((Object[])dependendies);
            }
        };
    }

    public static <T> ObjectBinding<T> compute(final Supplier<T> op, final ObservableValue<?> ... dependencies) {
        return new ObjectBinding<T>(){
            {
                super.bind((Observable[])dependencies);
            }

            protected T computeValue() {
                return op.get();
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.observableArrayList((Object[])dependencies);
            }
        };
    }

    public static <A, B> ObjectBinding<B> convert(final @NonNull ObservableValue<A> a, final @NonNull Function<A, B> convert) {
        return new ObjectBinding<B>(){
            {
                super.bind(new Observable[]{a});
            }

            protected B computeValue() {
                return convert.apply(a.getValue());
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.singletonObservableList((Object)a);
            }
        };
    }

    public static <A, B> ObservableValue<B> via(ObservableValue<A> root, Function<A, ObservableValue<B>> step) {
        ViaProperty<A, B> viaProperty = new ViaProperty<A, B>(step);
        root.addListener(viaProperty);
        viaProperty.changed(root, null, root.getValue());
        return viaProperty;
    }

    public static <A, B, C> ObservableValue<C> via(ObservableValue<A> root, Function<A, ObservableValue<B>> stepB, Function<B, ObservableValue<C>> stepC) {
        return CustomBinding.via(CustomBinding.via(root, stepB), stepC);
    }

    public static <A, B, C, D> ObservableValue<D> via(ObservableValue<A> root, Function<A, ObservableValue<B>> stepB, Function<B, ObservableValue<C>> stepC, Function<C, ObservableValue<D>> stepD) {
        return CustomBinding.via(CustomBinding.via(CustomBinding.via(root, stepB), stepC), stepD);
    }

    public static <A, B> Property<B> viaBidirectional(ObservableValue<A> root, Function<A, Property<B>> step) {
        SimpleObjectProperty viaProperty = new SimpleObjectProperty();
        ChangeListener changeListener = (o, oldValue, newValue) -> {
            if (oldValue != null) {
                viaProperty.unbindBidirectional((Property)step.apply(newValue));
            }
            if (newValue != null) {
                viaProperty.bindBidirectional((Property)step.apply(newValue));
            }
        };
        root.addListener(changeListener);
        changeListener.changed(root, null, root.getValue());
        return viaProperty;
    }

    public static <A, B, C> Property<C> viaBidirectional(ObservableValue<A> root, Function<A, ObservableValue<B>> stepB, Function<B, Property<C>> stepC) {
        return CustomBinding.viaBidirectional(CustomBinding.via(root, stepB), stepC);
    }

    public static <A, B, C, D> Property<D> viaBidirectional(ObservableValue<A> root, Function<A, ObservableValue<B>> stepB, Function<B, ObservableValue<C>> stepC, Function<C, Property<D>> stepD) {
        return CustomBinding.viaBidirectional(CustomBinding.via(CustomBinding.via(root, stepB), stepC), stepD);
    }

    private static class ViaProperty<AA, BB>
    extends SimpleObjectProperty<BB>
    implements ChangeListener<AA> {
        final Function<AA, ? extends ObservableValue<BB>> stepFunction;

        ViaProperty(Function<AA, ? extends ObservableValue<BB>> viaFunction) {
            this.stepFunction = viaFunction;
        }

        public void changed(ObservableValue<? extends AA> o, AA oldValue, AA newValue) {
            if (oldValue != null) {
                this.unbind();
            }
            if (newValue != null) {
                this.bind(this.stepFunction.apply(newValue));
            } else {
                this.set(null);
            }
        }

        protected void invalidated() {
            this.get();
        }
    }
}

