/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.binding;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxbase.binding.ConstantStringExpression;

public abstract class MessageStringFormatter
extends StringBinding {
    private MessageStringFormatter() {
    }

    private static Object extractValue(Object obj) {
        Object value;
        Object object = value = obj instanceof ObservableValue ? ((ObservableValue)obj).getValue() : obj;
        if (Boolean.TRUE.equals(value)) {
            return 1;
        }
        if (Boolean.FALSE.equals(value)) {
            return 0;
        }
        return value;
    }

    private static @NonNull Object[] extractValues(@NonNull Object[] objs) {
        int n = objs.length;
        Object[] values = new Object[n];
        for (int i = 0; i < n; ++i) {
            values[i] = MessageStringFormatter.extractValue(objs[i]);
        }
        return values;
    }

    private static @NonNull ObservableValue<?>[] extractDependencies(Object ... args) {
        ArrayList<ObservableValue> dependencies = new ArrayList<ObservableValue>();
        for (Object obj : args) {
            if (!(obj instanceof ObservableValue)) continue;
            dependencies.add((ObservableValue)obj);
        }
        return dependencies.toArray(new ObservableValue[0]);
    }

    public static @NonNull StringExpression format(final @Nullable String format, final Object ... args) {
        Objects.requireNonNull(format, "format");
        if (MessageStringFormatter.extractDependencies(args).length == 0) {
            return ConstantStringExpression.of(String.format(format, args));
        }
        MessageStringFormatter formatter = new MessageStringFormatter(){
            {
                super.bind(MessageStringFormatter.extractDependencies(args));
            }

            public void dispose() {
                super.unbind(MessageStringFormatter.extractDependencies(args));
            }

            protected @NonNull String computeValue() {
                Object[] values = MessageStringFormatter.extractValues(args);
                return MessageFormat.format(format, values);
            }

            public @NonNull ObservableList<ObservableValue<?>> getDependencies() {
                return FXCollections.unmodifiableObservableList((ObservableList)FXCollections.observableArrayList((Object[])MessageStringFormatter.extractDependencies(args)));
            }
        };
        formatter.get();
        return formatter;
    }
}

