/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.fxml;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javafx.fxml.FXMLLoader;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxbase.concurrent.FXWorker;

public class AsyncFxmlLoader {
    public static @NonNull CompletionStage<FXMLLoader> load(URL location) {
        return AsyncFxmlLoader.load(location, null, ForkJoinPool.commonPool());
    }

    public static @NonNull CompletionStage<FXMLLoader> load(URL location, ResourceBundle resources) {
        return AsyncFxmlLoader.load(location, resources, ForkJoinPool.commonPool());
    }

    public static @NonNull CompletionStage<FXMLLoader> load(@NonNull URL location, @Nullable ResourceBundle resources, @NonNull Executor executor) {
        return FXWorker.supply(executor, () -> {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(location);
            loader.setResources(resources);
            loader.load();
            return loader;
        });
    }
}

