/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxbase.spi.NodeReader;
import org.jhotdraw8.fxbase.spi.NodeReaderProvider;

public class NodeReaderRegistry {
    private NodeReaderRegistry() {
    }

    public static @NonNull List<NodeReader> getNodeReaders(@NonNull URL url) {
        ArrayList<NodeReader> list = new ArrayList<NodeReader>();
        for (NodeReaderProvider spi : ServiceLoader.load(NodeReaderProvider.class)) {
            if (!spi.canDecodeInput(url)) continue;
            list.add(spi.createReader());
        }
        return list;
    }

    public static @NonNull List<NodeReader> getNodeReaders(@NonNull String path) {
        ArrayList<NodeReader> list = new ArrayList<NodeReader>();
        for (NodeReaderProvider spi : ServiceLoader.load(NodeReaderProvider.class)) {
            if (!spi.canDecodeInput(path)) continue;
            list.add(spi.createReader());
        }
        return list;
    }

    public static @Nullable NodeReader getNodeReader(@NonNull URL url) {
        List<NodeReader> list = NodeReaderRegistry.getNodeReaders(url);
        return list.isEmpty() ? null : list.getFirst();
    }

    public static @Nullable NodeReader getNodeReader(@NonNull String path) {
        List<NodeReader> list = NodeReaderRegistry.getNodeReaders(path);
        return list.isEmpty() ? null : list.getFirst();
    }
}

