/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.styleable;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.css.StyleOrigin;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxbase.styleable.SimpleStyleableMap;
import org.jhotdraw8.fxbase.styleable.StyleableMap;
import org.jhotdraw8.fxbase.styleable.StyleablePropertyBean;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public abstract class AbstractStyleablePropertyBean
implements StyleablePropertyBean {
    protected static final Map<Class<?>, Map<Key<?>, Integer>> keyMaps = new ConcurrentHashMap();
    protected final StyleableMap<Key<?>, Object> properties = this.createStyleableMap();

    private @NonNull SimpleStyleableMap<Key<?>, Object> createStyleableMap() {
        return new SimpleStyleableMap<Key<?>, Object>(this.createKeyMap()){

            @Override
            protected void callObservers(@NonNull StyleOrigin origin, // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull MapChangeListener.Change<Key<?>, Object> change) {
                Object newValue;
                Key key = (Key)change.getKey();
                Object oldValue = change.wasRemoved() ? change.getValueRemoved() : key.getDefaultValue();
                Object object = newValue = change.wasAdded() ? change.getValueAdded() : key.getDefaultValue();
                if (!Objects.equals(oldValue, newValue)) {
                    AbstractStyleablePropertyBean.this.onPropertyChanged(key, oldValue, newValue, change.wasAdded(), change.wasRemoved());
                    AbstractStyleablePropertyBean.this.callObservers(origin, false, change);
                    super.callObservers(origin, change);
                }
            }
        };
    }

    protected @NonNull Map<Key<?>, Integer> createKeyMap() {
        return keyMaps.computeIfAbsent(this.getClass(), k -> {
            IdentityHashMap m = new IdentityHashMap<Key<?>, Integer>(){
                private static final long serialVersionUID = 0L;
                final @NonNull AtomicInteger nextIndex = new AtomicInteger();

                @Override
                public Integer get(Object key) {
                    Integer v = (Integer)super.get(key);
                    if (v == null) {
                        Integer newValue = this.nextIndex.getAndIncrement();
                        this.put((Key)key, newValue);
                        return newValue;
                    }
                    return v;
                }
            };
            return m;
        });
    }

    @Override
    public final @NonNull ObservableMap<Key<?>, Object> getProperties() {
        return this.properties;
    }

    protected @NonNull StyleableMap<Key<?>, Object> getStyleableMap() {
        return this.properties;
    }

    @Override
    public <T> @Nullable T getStyled(@NonNull MapAccessor<T> key) {
        StyleableMap<Key<?>, Object> map = this.getStyleableMap();
        Object ret = key.get(map.getStyledMap());
        return (T)ret;
    }

    @Override
    public <T> T getStyled(@Nullable StyleOrigin origin, @NonNull MapAccessor<T> key) {
        if (origin == null) {
            return this.getStyled(key);
        }
        Map<Key<?>, Object> map = this.getStyleableMap().getMap(origin);
        return (T)key.get(map);
    }

    @Override
    public <T> boolean containsMapAccessor(@NonNull StyleOrigin origin, @NonNull MapAccessor<T> key) {
        return key.containsKey(this.getStyleableMap().getMap(origin));
    }

    @Override
    public <T> @Nullable T setStyled(@NonNull StyleOrigin origin, @NonNull MapAccessor<T> key, T newValue) {
        StyleableMap<Key<?>, Object> map = this.getStyleableMap();
        Object ret = key.put(map.getMap(origin), newValue);
        return (T)ret;
    }

    @Override
    public <T> @Nullable T remove(@NonNull StyleOrigin origin, @NonNull MapAccessor<T> key) {
        Object ret = key.remove(this.getStyleableMap().getMap(origin));
        return (T)ret;
    }

    @Override
    public void removeAll(@NonNull StyleOrigin origin) {
        this.getStyleableMap().removeAll(origin);
    }

    protected <T> void onPropertyChanged(Key<T> key, T oldValue, T newValue, boolean wasAdded, boolean wasRemoved) {
    }

    protected void callObservers(StyleOrigin origin, boolean willChange, MapChangeListener.Change<Key<?>, Object> change) {
    }

    @Override
    public void resetStyledValues() {
        this.properties.resetStyledValues();
    }
}

