/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.tree;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.fxbase.beans.ObservableMixin;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;

public interface TreeModel<N>
extends ObservableMixin {
    public static final String ROOT_PROPERTY = "root";

    public @NonNull CopyOnWriteArrayList<Listener<TreeModelEvent<N>>> getTreeModelListeners();

    @Override
    public @NonNull CopyOnWriteArrayList<InvalidationListener> getInvalidationListeners();

    public @NonNull ObjectProperty<N> rootProperty();

    default public void addTreeModelListener(@NonNull Listener<TreeModelEvent<N>> l) {
        this.getTreeModelListeners().add(l);
    }

    default public void removeTreeModelListener(@NonNull Listener<TreeModelEvent<N>> l) {
        this.getTreeModelListeners().remove(l);
    }

    default public @Nullable N getRoot() {
        return (N)this.rootProperty().get();
    }

    default public void setRoot(@Nullable N root) {
        this.rootProperty().set(root);
    }

    public @NonNull List<N> getChildren(@NonNull N var1);

    public int getChildCount(@NonNull N var1);

    public @NonNull N getChild(@NonNull N var1, int var2);

    public void removeFromParent(@NonNull N var1);

    public void insertChildAt(@NonNull N var1, @NonNull N var2, int var3);

    default public void addChildTo(@NonNull N child, @NonNull N parent) {
        this.insertChildAt(child, parent, this.getChildCount(parent));
    }

    default public void fireTreeModelEvent(@NonNull TreeModelEvent<N> event) {
        for (Listener<TreeModelEvent<N>> l : this.getTreeModelListeners()) {
            l.handle(event);
        }
    }

    default public void fireNodeInvalidated(@NonNull N node) {
        this.fireTreeModelEvent(TreeModelEvent.nodeChanged(this, node));
    }
}

