/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.undo;

import java.util.function.Consumer;
import javax.swing.event.UndoableEditEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxbase.undo.CompositeEdit;

public class UndoableEditHelper {
    private @Nullable CompositeEdit edit;
    private final @NonNull Consumer<UndoableEditEvent> handler;
    private final @NonNull Object source;

    public UndoableEditHelper(@NonNull Object source, @NonNull Consumer<UndoableEditEvent> handler) {
        this.handler = handler;
        this.source = source;
    }

    public void startCompositeEdit(@Nullable String localizedName) {
        if (this.edit == null) {
            this.edit = new CompositeEdit(localizedName);
            this.fire(this.edit);
        }
    }

    private void fire(CompositeEdit edit) {
        new UndoableEditEvent(this.source, edit);
    }

    public void stopCompositeEdit() {
        if (this.edit != null) {
            this.fire(this.edit);
            this.edit = null;
        }
    }
}

