/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.beans;

import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;

public interface ObservableMixin
extends Observable {
    public CopyOnWriteArrayList<InvalidationListener> getInvalidationListeners();

    default public void addListener(InvalidationListener listener) {
        this.getInvalidationListeners().add(listener);
    }

    default public void removeListener(InvalidationListener listener) {
        this.getInvalidationListeners().remove(listener);
    }

    default public void fireInvalidated(Observable o) {
        this.invalidated();
        CopyOnWriteArrayList<InvalidationListener> listeners = this.getInvalidationListeners();
        if (!listeners.isEmpty()) {
            for (InvalidationListener l : listeners) {
                l.invalidated((Observable)this);
            }
        }
    }

    default public void fireInvalidated() {
        this.fireInvalidated(this);
    }

    default public void invalidated() {
    }
}

