/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.beans;

import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import org.jhotdraw8.fxcollection.MapEntryProperty;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jspecify.annotations.Nullable;

public interface PropertyBean {
    public ObservableMap<Key<?>, Object> getProperties();

    default public <T> ObjectProperty<T> getProperty(Key<T> key) {
        return new MapEntryProperty(this.getProperties(), key, key.getValueType());
    }

    default public <T> void set(MapAccessor<T> key, @Nullable T newValue) {
        key.set(this.getProperties(), newValue);
    }

    default public <T> void setNonNull(NonNullMapAccessor<T> key, T newValue) {
        key.set(this.getProperties(), newValue);
    }

    default public <T> @Nullable T put(MapAccessor<T> key, @Nullable T newValue) {
        return (T)key.put(this.getProperties(), newValue);
    }

    default public <T> @Nullable T get(MapAccessor<T> key) {
        return (T)key.get(this.getProperties());
    }

    default public <T> T getNonNull(NonNullMapAccessor<T> key) {
        Object value = key.get(this.getProperties());
        return (T)Objects.requireNonNull(value, "value is null for key=" + String.valueOf(key));
    }

    default public <T> @Nullable T remove(Key<T> key) {
        return key.getRawValueType().cast(this.getProperties().remove(key));
    }

    default public <T> ObservableValue<T> valueAt(Key<T> key) {
        return Bindings.valueAt(this.getProperties(), key);
    }
}

