/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.binding;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;

public class StrongBidirectionalBinding<T>
implements InvalidationListener {
    private final Property<T> propertyRef1;
    private final Property<T> propertyRef2;
    private T oldValue;
    private boolean updating = false;

    private StrongBidirectionalBinding(Property<T> property1, Property<T> property2) {
        this.oldValue = property1.getValue();
        this.propertyRef1 = property1;
        this.propertyRef2 = property2;
    }

    protected Property<T> getProperty1() {
        return this.propertyRef1;
    }

    protected Property<T> getProperty2() {
        return this.propertyRef2;
    }

    public void invalidated(Observable sourceProperty) {
        if (!this.updating) {
            Property<T> property1 = this.propertyRef1;
            Property<T> property2 = this.propertyRef2;
            if (property1 == null || property2 == null) {
                if (property1 != null) {
                    property1.removeListener((InvalidationListener)this);
                }
                if (property2 != null) {
                    property2.removeListener((InvalidationListener)this);
                }
            } else {
                try {
                    this.updating = true;
                    if (property1 == sourceProperty) {
                        Object newValue = property1.getValue();
                        property2.setValue(newValue);
                        this.oldValue = newValue;
                    } else {
                        Object newValue = property2.getValue();
                        property1.setValue(newValue);
                        this.oldValue = newValue;
                    }
                }
                catch (RuntimeException e) {
                    try {
                        if (property1 == sourceProperty) {
                            property1.setValue(this.oldValue);
                        } else {
                            property2.setValue(this.oldValue);
                        }
                    }
                    catch (Exception e2) {
                        e2.addSuppressed(e);
                        StrongBidirectionalBinding.unbind(property1, property2);
                        throw new RuntimeException("StrongBidirectionalBinding binding failed together with an attempt to restore the source property to the previous value. Removing the bidirectional binding from properties " + String.valueOf(property1) + " and " + String.valueOf(property2), e2);
                    }
                    throw new RuntimeException("StrongBidirectionalBinding binding failed, setting to the previous value", e);
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrongBidirectionalBinding that = (StrongBidirectionalBinding)o;
        return this.updating == that.updating && Objects.equals(this.propertyRef1, that.propertyRef1) && Objects.equals(this.propertyRef2, that.propertyRef2) && Objects.equals(this.oldValue, that.oldValue);
    }

    public int hashCode() {
        return Objects.hash(this.propertyRef1, this.propertyRef2, this.oldValue, this.updating);
    }

    public static <T> void unbind(Property<T> property1, Property<T> property2) {
        StrongBidirectionalBinding<T> binding = new StrongBidirectionalBinding<T>(property1, property2);
        property1.removeListener(binding);
        property2.removeListener(binding);
    }

    public static <T> StrongBidirectionalBinding<T> bind(Property<T> property1, Property<T> property2) {
        StrongBidirectionalBinding<T> binding = new StrongBidirectionalBinding<T>(property1, property2);
        property1.setValue(property2.getValue());
        property1.addListener(binding);
        property2.addListener(binding);
        return binding;
    }
}

