/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import org.jhotdraw8.base.concurrent.CheckedFunction;
import org.jhotdraw8.base.concurrent.CheckedRunnable;
import org.jhotdraw8.fxbase.concurrent.CompletableWorker;
import org.jhotdraw8.fxbase.concurrent.SimpleCompletableWorker;
import org.jhotdraw8.fxbase.concurrent.WorkState;

public class FXWorker {
    private FXWorker() {
    }

    public static CompletableFuture<Void> run(CheckedRunnable runnable) {
        return FXWorker.run(ForkJoinPool.commonPool(), runnable);
    }

    public static CompletableFuture<Void> run(Executor executor, CheckedRunnable runnable) {
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        Runnable worker = () -> {
            try {
                runnable.run();
                Platform.runLater(() -> f.complete(null));
            }
            catch (Exception e) {
                Platform.runLater(() -> f.completeExceptionally(e));
            }
        };
        executor.execute(worker);
        return f;
    }

    public static <T> CompletableFuture<T> supply(Callable<T> supplier) {
        return FXWorker.supply(ForkJoinPool.commonPool(), supplier);
    }

    public static <T> CompletableFuture<T> supply(Executor executor, Callable<T> supplier) {
        CompletableFuture f = new CompletableFuture();
        executor.execute(() -> {
            try {
                Object result = supplier.call();
                Platform.runLater(() -> f.complete(result));
            }
            catch (Throwable e) {
                Platform.runLater(() -> f.completeExceptionally(e));
            }
        });
        return f;
    }

    public static <T> CompletableWorker<T> work(Executor executor, CheckedFunction<WorkState<T>, T> supplier, WorkState<T> workState) {
        SimpleCompletableWorker w = new SimpleCompletableWorker(workState);
        w.updateState(Worker.State.SCHEDULED);
        executor.execute(() -> {
            try {
                w.updateState(Worker.State.RUNNING);
                Object result = supplier.apply((Object)workState);
                Platform.runLater(() -> w.complete(result));
            }
            catch (Throwable e) {
                Platform.runLater(() -> w.completeExceptionally(e));
            }
        });
        return w;
    }
}

