/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.Property;
import org.jhotdraw8.fxbase.concurrent.RunnableWithException;
import org.jspecify.annotations.Nullable;

public class PlatformUtil {
    static final Object NO_UPDATE_IS_IN_PROGRESS = new Object();

    private PlatformUtil() {
    }

    static <X> void update(@Nullable X newValue, Property<X> property, AtomicReference<Object> propertyUpdate) {
        if (Platform.isFxApplicationThread()) {
            property.setValue(newValue);
        } else if (propertyUpdate.getAndSet(newValue) == NO_UPDATE_IS_IN_PROGRESS) {
            Platform.runLater(() -> {
                Object andSet = propertyUpdate.getAndSet(NO_UPDATE_IS_IN_PROGRESS);
                property.setValue(andSet);
            });
        }
    }

    public static void invokeAndWait(RunnableWithException r) {
        PlatformUtil.invokeAndWait(60000L, r);
    }

    public static void invokeAndWait(long timeout, RunnableWithException r) {
        CompletableFuture f = new CompletableFuture();
        Platform.runLater(() -> {
            try {
                r.run();
                f.complete(null);
            }
            catch (Throwable t) {
                f.completeExceptionally(t);
            }
        });
        try {
            f.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T callAndWait(Callable<T> r) {
        return PlatformUtil.callAndWait(60000L, r);
    }

    public static <T> T callAndWait(long timeout, Callable<T> r) {
        CompletableFuture f = new CompletableFuture();
        Platform.runLater(() -> {
            try {
                f.complete(r.call());
            }
            catch (Throwable t) {
                f.completeExceptionally(t);
            }
        });
        try {
            return f.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }
}

