/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.concurrent.Worker;
import org.jhotdraw8.fxbase.concurrent.CompletableWorker;
import org.jhotdraw8.fxbase.concurrent.PlatformUtil;
import org.jhotdraw8.fxbase.concurrent.WorkState;

public class SimpleCompletableWorker<V>
implements CompletableWorker<V> {
    private static final Object NO_UPDATE_IS_IN_PROGRESS = new Object();
    private final WorkState<V> workState;
    private final CompletableFuture<V> completableFuture = new CompletableFuture();
    private final ReadOnlyObjectWrapper<Worker.State> state = new ReadOnlyObjectWrapper((Object)this, "state", (Object)Worker.State.READY);
    private final AtomicReference<Object> stateUpdate = new AtomicReference<Object>(NO_UPDATE_IS_IN_PROGRESS);
    private final ReadOnlyObjectWrapper<Throwable> exception = new ReadOnlyObjectWrapper((Object)this, "exception", null);
    private final AtomicReference<Object> exceptionUpdate = new AtomicReference<Object>(NO_UPDATE_IS_IN_PROGRESS);
    private final ReadOnlyBooleanWrapper running = new ReadOnlyBooleanWrapper((Object)this, "running", true);
    private final AtomicReference<Object> runningUpdate = new AtomicReference<Object>(NO_UPDATE_IS_IN_PROGRESS);

    public SimpleCompletableWorker(WorkState<V> workState) {
        this.workState = workState;
    }

    @Override
    public CompletionStage<V> getCompletionStage() {
        return this.completableFuture;
    }

    public Worker.State getState() {
        return (Worker.State)this.state.get();
    }

    public ReadOnlyObjectProperty<Worker.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public void updateState(Worker.State newValue) {
        PlatformUtil.update(newValue, this.state, this.stateUpdate);
    }

    public V getValue() {
        return this.workState.getValue();
    }

    public ReadOnlyObjectProperty<V> valueProperty() {
        return this.workState.valueProperty();
    }

    public Throwable getException() {
        return (Throwable)this.exception.get();
    }

    public ReadOnlyObjectProperty<Throwable> exceptionProperty() {
        return this.exception.getReadOnlyProperty();
    }

    public double getWorkDone() {
        return this.workState.getWorkDone();
    }

    public ReadOnlyDoubleProperty workDoneProperty() {
        return this.workState.workDoneProperty();
    }

    public double getTotalWork() {
        return this.workState.getTotalWork();
    }

    public ReadOnlyDoubleProperty totalWorkProperty() {
        return this.workState.totalWorkProperty();
    }

    public double getProgress() {
        return this.workState.getProgress();
    }

    public ReadOnlyDoubleProperty progressProperty() {
        return this.workState.progressProperty();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public ReadOnlyBooleanProperty runningProperty() {
        return this.running.getReadOnlyProperty();
    }

    public String getMessage() {
        return this.workState.getMessage();
    }

    public ReadOnlyStringProperty messageProperty() {
        return this.workState.messageProperty();
    }

    public String getTitle() {
        return this.workState.getTitle();
    }

    public ReadOnlyStringProperty titleProperty() {
        return this.workState.titleProperty();
    }

    public boolean cancel() {
        this.workState.cancel();
        return this.completableFuture.cancel(true);
    }

    public void updateException(Throwable value) {
        PlatformUtil.update(value, this.exception, this.exceptionUpdate);
    }

    @Override
    public void complete(V result) {
        this.workState.updateValue(result);
        this.updateState(Worker.State.SUCCEEDED);
        PlatformUtil.update(false, this.running, this.runningUpdate);
        this.completableFuture.complete(result);
    }

    @Override
    public void completeExceptionally(Throwable exception) {
        this.updateException(exception);
        this.updateState(Worker.State.FAILED);
        PlatformUtil.update(false, this.running, this.runningUpdate);
        this.completableFuture.completeExceptionally(exception);
    }
}

