/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.control;

import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;

public class InputDialog<R>
extends Dialog<R> {
    private Node inputForm;
    private Supplier<R> resultSupplier;

    public InputDialog(String title, String headerText, Node inputForm, Supplier<R> resultSupplier) {
        DialogPane dialogPane = this.getDialogPane();
        this.inputForm = inputForm;
        dialogPane.contentTextProperty().addListener(o -> this.updateGrid());
        this.setTitle(title);
        dialogPane.setHeaderText(headerText);
        dialogPane.getStyleClass().add((Object)"text-input-dialog");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.updateGrid();
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? resultSupplier.get() : null;
        });
    }

    public final Node getInputForm() {
        return this.inputForm;
    }

    public final void setInputForm(Node newValue) {
        this.inputForm = newValue;
        this.updateGrid();
    }

    public Supplier<R> getResultSupplier() {
        return this.resultSupplier;
    }

    public void setResultSupplier(Supplier<R> resultSupplier) {
        this.resultSupplier = resultSupplier;
    }

    private void updateGrid() {
        this.getDialogPane().setContent(this.inputForm);
        Platform.runLater(() -> this.inputForm.requestFocus());
    }
}

