/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import javax.swing.event.UndoableEditEvent;
import org.jhotdraw8.fxbase.clipboard.ClipboardIO;
import org.jhotdraw8.fxbase.undo.UndoableEditHelper;
import org.jspecify.annotations.Nullable;

public class ListViewUtil {
    private ListViewUtil() {
    }

    public static <T> void addDragAndDropSupport(ListView<T> listView, ClipboardIO<T> clipboardIO) {
        ListViewUtil.addDragAndDropSupport(listView, listView.getCellFactory(), clipboardIO, undoableEditEvent -> {});
    }

    public static <T> void addDragAndDropSupport(ListView<T> listView, ClipboardIO<T> clipboardIO, Consumer<UndoableEditEvent> undoableEditEventConsumer) {
        ListViewUtil.addDragAndDropSupport(listView, listView.getCellFactory(), clipboardIO, undoableEditEventConsumer);
    }

    public static <T> void addDragAndDropSupport(ListView<T> listView, @Nullable Callback<ListView<T>, ListCell<T>> cellFactory, ClipboardIO<T> clipboardIO, Consumer<UndoableEditEvent> undoableEditEventConsumer) {
        ListViewUtil.addDragAndDropSupport(listView, cellFactory, clipboardIO, false, undoableEditEventConsumer);
    }

    private static <T> void addDragAndDropSupport(ListView<T> listView, @Nullable Callback<ListView<T>, ListCell<T>> cellFactory, ClipboardIO<T> clipboardIO, boolean reorderingOnly, Consumer<UndoableEditEvent> undoableEditEventConsumer) {
        DnDSupport<T> dndSupport = new DnDSupport<T>(listView, clipboardIO, reorderingOnly, undoableEditEventConsumer);
        Callback dndCellFactory = lv -> {
            ListCell cell = cellFactory == null ? new SimpleListCell() : (ListCell)cellFactory.call(lv);
            cell.addEventHandler(DragEvent.ANY, dndSupport.cellDragHandler);
            cell.addEventHandler(MouseEvent.DRAG_DETECTED, dndSupport.cellMouseHandler);
            return cell;
        };
        listView.setCellFactory(dndCellFactory);
        listView.addEventHandler(DragEvent.ANY, dndSupport.listDragHandler);
    }

    public static <T> void addReorderingSupport(ListView<T> listView, Consumer<UndoableEditEvent> undoableEditEventConsumer) {
        ListViewUtil.addReorderingSupport(listView, listView.getCellFactory(), null, undoableEditEventConsumer);
    }

    public static <T> void addReorderingSupport(ListView<T> listView, ClipboardIO<T> clipboardIO, Consumer<UndoableEditEvent> undoableEditEventConsumer) {
        ListViewUtil.addReorderingSupport(listView, listView.getCellFactory(), clipboardIO, undoableEditEventConsumer);
    }

    public static <T> void addReorderingSupport(final ListView<T> listView, Callback<ListView<T>, ListCell<T>> cellFactory, @Nullable ClipboardIO<T> clipboardIO, Consumer<UndoableEditEvent> undoableEditEventConsumer) {
        if (clipboardIO == null) {
            clipboardIO = new ClipboardIO<T>(){

                @Override
                public void write(Clipboard clipboard, List<T> items) {
                    if (items.size() != 1) {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                    ClipboardContent content = new ClipboardContent();
                    content.putString("" + listView.getSelectionModel().getSelectedIndex());
                    clipboard.setContent((Map)content);
                }

                @Override
                public List<T> read(Clipboard clipboard) {
                    return Collections.emptyList();
                }

                @Override
                public boolean canRead(Clipboard clipboard) {
                    return clipboard.hasString();
                }
            };
        }
        ListViewUtil.addDragAndDropSupport(listView, cellFactory, clipboardIO, true, undoableEditEventConsumer);
    }

    private static class DnDSupport<T> {
        private final ListView<T> listView;
        private int draggedCellIndex = -1;
        private final ClipboardIO<T> io;
        private final boolean reorderingOnly;
        private final UndoableEditHelper undoHelper;
        private final EventHandler<? super DragEvent> cellDragHandler = new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                if (event.isConsumed()) {
                    return;
                }
                EventType t = event.getEventType();
                if (t == DragEvent.DRAG_DONE) {
                    this.onDragDone(event);
                } else if (t == DragEvent.DRAG_DROPPED) {
                    this.onDragDropped(event);
                } else if (t == DragEvent.DRAG_OVER) {
                    this.onDragOver(event);
                }
            }

            private void onDragDone(DragEvent event) {
                if (reorderingOnly) {
                    draggedCellIndex = -1;
                    event.consume();
                    return;
                }
                if (event.getAcceptedTransferMode() == TransferMode.MOVE) {
                    listView.getItems().remove(draggedCellIndex);
                }
                event.consume();
            }

            private TransferMode[] acceptModes(DragEvent event) {
                TransferMode[] mode;
                ListView gestureTargetListView = null;
                Object object = event.getGestureSource();
                if (object instanceof ListCell) {
                    ListCell gestureTargetCell = (ListCell)object;
                    gestureTargetListView = gestureTargetCell.getListView();
                }
                if (reorderingOnly) {
                    TransferMode[] transferModeArray;
                    if (listView == gestureTargetListView) {
                        TransferMode[] transferModeArray2 = new TransferMode[1];
                        transferModeArray = transferModeArray2;
                        transferModeArray2[0] = TransferMode.MOVE;
                    } else {
                        transferModeArray = TransferMode.NONE;
                    }
                    mode = transferModeArray;
                } else {
                    TransferMode[] transferModeArray;
                    if (listView == gestureTargetListView) {
                        TransferMode[] transferModeArray3 = new TransferMode[1];
                        transferModeArray = transferModeArray3;
                        transferModeArray3[0] = TransferMode.MOVE;
                    } else {
                        TransferMode[] transferModeArray4 = new TransferMode[1];
                        transferModeArray = transferModeArray4;
                        transferModeArray4[0] = TransferMode.COPY;
                    }
                    mode = transferModeArray;
                }
                return mode;
            }

            private void onDragDropped(DragEvent event) {
                boolean isAcceptable = io.canRead((Clipboard)event.getDragboard());
                if (isAcceptable) {
                    boolean success = false;
                    TransferMode[] mode = this.acceptModes(event);
                    if (mode.length == 0) {
                        return;
                    }
                    event.acceptTransferModes(mode);
                    ListCell source = (ListCell)event.getSource();
                    int droppedCellIndex = source.getIndex();
                    ObservableList listViewItems = listView.getItems();
                    if (reorderingOnly) {
                        int to;
                        int n = to = draggedCellIndex < droppedCellIndex ? Math.min(listViewItems.size(), droppedCellIndex) : Math.min(listViewItems.size() - 1, droppedCellIndex + 1);
                        if (to < 0) {
                            success = false;
                        } else {
                            Object item = listViewItems.get(draggedCellIndex);
                            listViewItems.add(to, item);
                            success = true;
                        }
                    } else {
                        List items = io.read((Clipboard)event.getDragboard());
                        boolean bl = success = items != null;
                        if (success) {
                            for (Object item : items) {
                                listViewItems.add(Math.min(droppedCellIndex, listViewItems.size()), item);
                                if (droppedCellIndex <= draggedCellIndex) {
                                    ++draggedCellIndex;
                                }
                                ++droppedCellIndex;
                            }
                        }
                    }
                    event.setDropCompleted(success);
                    event.consume();
                }
            }

            private void onDragOver(DragEvent event) {
                boolean isAcceptable = io.canRead((Clipboard)event.getDragboard());
                if (isAcceptable && (!reorderingOnly || draggedCellIndex != -1)) {
                    event.acceptTransferModes(this.acceptModes(event));
                    event.consume();
                }
            }
        };
        private final EventHandler<? super MouseEvent> cellMouseHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.isConsumed()) {
                    return;
                }
                if (event.getEventType() == MouseEvent.DRAG_DETECTED) {
                    TransferMode[] transferModeArray;
                    ListCell draggedCell = (ListCell)event.getSource();
                    draggedCellIndex = draggedCell.getIndex();
                    if (!listView.getSelectionModel().isSelected(draggedCell.getIndex())) {
                        return;
                    }
                    if (reorderingOnly) {
                        TransferMode[] transferModeArray2 = new TransferMode[1];
                        transferModeArray = transferModeArray2;
                        transferModeArray2[0] = TransferMode.MOVE;
                    } else {
                        transferModeArray = TransferMode.COPY_OR_MOVE;
                    }
                    Dragboard dragboard = draggedCell.startDragAndDrop(transferModeArray);
                    ArrayList<Object> items = new ArrayList<Object>();
                    items.add(draggedCell.getItem());
                    io.write((Clipboard)dragboard, items);
                    dragboard.setDragView((Image)draggedCell.snapshot(new SnapshotParameters(), null));
                    event.consume();
                }
            }
        };
        final EventHandler<? super DragEvent> listDragHandler = new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                if (event.isConsumed()) {
                    return;
                }
                EventType t = event.getEventType();
                if (t == DragEvent.DRAG_DROPPED) {
                    this.onDragDropped(event);
                } else if (t == DragEvent.DRAG_OVER) {
                    this.onDragOver(event);
                }
            }

            private TransferMode[] acceptModes(DragEvent event) {
                TransferMode[] mode;
                ListView gestureTargetListView = null;
                Object object = event.getGestureSource();
                if (object instanceof ListCell) {
                    ListCell gestureTargetCell = (ListCell)object;
                    gestureTargetListView = gestureTargetCell.getListView();
                }
                if (reorderingOnly) {
                    TransferMode[] transferModeArray;
                    if (listView == gestureTargetListView) {
                        TransferMode[] transferModeArray2 = new TransferMode[1];
                        transferModeArray = transferModeArray2;
                        transferModeArray2[0] = TransferMode.MOVE;
                    } else {
                        transferModeArray = TransferMode.NONE;
                    }
                    mode = transferModeArray;
                } else {
                    TransferMode[] transferModeArray;
                    if (listView == gestureTargetListView) {
                        TransferMode[] transferModeArray3 = new TransferMode[1];
                        transferModeArray = transferModeArray3;
                        transferModeArray3[0] = TransferMode.MOVE;
                    } else {
                        TransferMode[] transferModeArray4 = new TransferMode[1];
                        transferModeArray = transferModeArray4;
                        transferModeArray4[0] = TransferMode.COPY;
                    }
                    mode = transferModeArray;
                }
                return mode;
            }

            private void onDragDropped(DragEvent event) {
                boolean isAcceptable = io.canRead((Clipboard)event.getDragboard());
                if (isAcceptable) {
                    undoHelper.startCompositeEdit(null);
                    boolean success = false;
                    TransferMode[] mode = this.acceptModes(event);
                    if (mode.length == 0) {
                        return;
                    }
                    event.acceptTransferModes(mode);
                    double cellHeight = listView.getFixedCellSize();
                    int index = Math.max(0, Math.min((int)(event.getY() / cellHeight), listView.getItems().size()));
                    if (reorderingOnly) {
                        Object item = listView.getItems().get(draggedCellIndex);
                        listView.getItems().add(index, item);
                        success = true;
                    } else {
                        List items = io.read((Clipboard)event.getDragboard());
                        boolean bl = success = items != null;
                        if (success) {
                            for (Object item : items) {
                                listView.getItems().add(index, item);
                                if (index <= draggedCellIndex) {
                                    ++draggedCellIndex;
                                }
                                ++index;
                            }
                        }
                    }
                    event.setDropCompleted(success);
                    event.consume();
                    undoHelper.stopCompositeEdit();
                }
            }

            private void onDragOver(DragEvent event) {
                boolean isAcceptable = io.canRead((Clipboard)event.getDragboard());
                if (isAcceptable && (!reorderingOnly || draggedCellIndex != -1)) {
                    event.acceptTransferModes(this.acceptModes(event));
                    event.consume();
                }
            }
        };

        public DnDSupport(ListView<T> listView, ClipboardIO<T> io, boolean reorderingOnly, Consumer<UndoableEditEvent> undoableEditEventConsumer) {
            this.listView = listView;
            this.io = io;
            this.reorderingOnly = reorderingOnly;
            this.undoHelper = new UndoableEditHelper(listView, undoableEditEventConsumer);
        }
    }

    static class SimpleListCell<T>
    extends ListCell<T> {
        SimpleListCell() {
        }

        public void updateItem(T var1, boolean var2) {
            super.updateItem(var1, var2);
            if (var2) {
                this.setText(null);
                this.setGraphic(null);
            } else if (var1 instanceof Node) {
                Node var4 = (Node)var1;
                this.setText(null);
                Node var3 = this.getGraphic();
                if (var3 == null || !var3.equals(var4)) {
                    this.setGraphic(var4);
                }
            } else {
                this.setText(var1 == null ? "null" : var1.toString());
                this.setGraphic(null);
            }
        }
    }
}

