/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.control;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.UnaryOperator;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputControl;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jspecify.annotations.Nullable;

public class TextInputControlUndoAdapter
implements UnaryOperator<TextFormatter.Change> {
    private final CopyOnWriteArrayList<UndoableEditListener> listeners = new CopyOnWriteArrayList();

    public TextInputControlUndoAdapter() {
    }

    public TextInputControlUndoAdapter(TextInputControl control) {
        this.bind(control);
    }

    public void bind(TextInputControl control) {
        control.setTextFormatter(new TextFormatter((UnaryOperator)this));
    }

    public void unbind(TextInputControl control) {
        control.setTextFormatter(null);
    }

    public void addUndoEditListener(UndoableEditListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public TextFormatter.Change apply(TextFormatter.Change change) {
        if (!this.listeners.isEmpty()) {
            String deletedText = change.isDeleted() ? change.getControlText().substring(change.getRangeStart(), change.getRangeEnd()) : null;
            String addedText = change.isAdded() ? change.getText() : null;
            UndoableEditEvent event = new UndoableEditEvent(change.getControl(), new UndoableTextEdit((TextInputControl)change.getControl(), addedText, deletedText, change.getRangeStart(), change.getRangeEnd(), change.getAnchor(), change.getCaretPosition(), change.getControlAnchor(), change.getControlCaretPosition()));
            this.listeners.forEach(l -> l.undoableEditHappened(event));
        }
        return change;
    }

    public void removeUndoEditListener(UndoableEditListener listener) {
        this.listeners.remove(listener);
    }

    static class UndoableTextEdit
    extends AbstractUndoableEdit {
        private @Nullable TextInputControl control;
        private String addedText;
        private String deletedText;
        private int start;
        private int end;
        private int newAnchor;
        private int newCaret;
        private final int oldAnchor;
        private final int oldCaret;

        public UndoableTextEdit(TextInputControl control, @Nullable String addedText, @Nullable String deletedText, int start, int end, int newAnchor, int newCaret, int oldAnchor, int oldCaret) {
            this.control = control;
            this.addedText = addedText == null ? "" : addedText;
            this.deletedText = deletedText == null ? "" : deletedText;
            this.start = start;
            this.end = end;
            this.newAnchor = newAnchor;
            this.newCaret = newCaret;
            this.oldAnchor = oldAnchor;
            this.oldCaret = oldCaret;
        }

        private boolean isDeleted() {
            return this.start != this.end;
        }

        private boolean isAdded() {
            return !this.addedText.isEmpty();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            TextInputControl c = this.control;
            assert (c != null);
            if (this.isAdded()) {
                c.deleteText(this.start, this.start + this.addedText.length());
            }
            if (this.isDeleted()) {
                c.insertText(this.start, this.deletedText);
            }
            c.selectRange(this.oldAnchor, this.oldCaret);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            TextInputControl c = this.control;
            assert (c != null);
            if (this.isDeleted()) {
                c.deleteText(new IndexRange(this.start, this.end));
            }
            if (this.isAdded()) {
                c.insertText(this.start, this.addedText);
            }
            c.selectRange(this.newAnchor, this.newCaret);
        }

        @Override
        public void die() {
            super.die();
            this.control = null;
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof UndoableTextEdit) {
                UndoableTextEdit e = (UndoableTextEdit)anEdit;
                if (e.control == this.control) {
                    if (!this.isSignificant() && !e.isSignificant()) {
                        this.newAnchor = e.newAnchor;
                        this.newCaret = e.newCaret;
                        e.die();
                        return true;
                    }
                    if (this.isAdded() && !this.isDeleted() && e.isAdded() && !e.isDeleted() && this.start + this.addedText.length() == e.start && Character.isWhitespace(this.addedText.charAt(this.addedText.length() - 1)) == Character.isWhitespace(e.addedText.charAt(0))) {
                        this.addedText = this.addedText + e.addedText;
                        this.newAnchor = e.newAnchor;
                        this.newCaret = e.newCaret;
                        e.die();
                        return true;
                    }
                    if (!this.isAdded() && this.isDeleted() && !e.isAdded() && e.isDeleted()) {
                        if (this.start == e.start && Character.isWhitespace(this.deletedText.charAt(this.deletedText.length() - 1)) == Character.isWhitespace(e.deletedText.charAt(0))) {
                            this.deletedText = this.deletedText + e.deletedText;
                            this.end = this.start + this.deletedText.length();
                            this.newAnchor = e.newAnchor;
                            this.newCaret = e.newCaret;
                            e.die();
                            return true;
                        }
                        if (this.start == e.end && Character.isWhitespace(this.deletedText.charAt(this.deletedText.length() - 1)) == Character.isWhitespace(e.deletedText.charAt(0))) {
                            this.deletedText = e.deletedText + this.deletedText;
                            this.start = this.end - this.deletedText.length();
                            this.newAnchor = e.newAnchor;
                            this.newCaret = e.newCaret;
                            e.die();
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public boolean isSignificant() {
            return this.isDeleted() || this.isAdded();
        }

        @Override
        public String getPresentationName() {
            return "Typing";
        }

        @Override
        public String toString() {
            return super.toString() + " control: " + String.valueOf(this.control) + " addedText: '" + this.addedText + "' deletedText: '" + this.deletedText + "' start: " + this.start + " end: " + this.end + " newAnchor: " + this.newAnchor + " newCaret: " + this.newCaret + " oldAnchor: " + this.oldAnchor + " oldCaret: " + this.oldCaret;
        }
    }
}

