/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jhotdraw8.fxbase.spi.NodeReader;
import org.jhotdraw8.fxbase.spi.NodeReaderProvider;
import org.jspecify.annotations.Nullable;

public class NodeReaderRegistry {
    private NodeReaderRegistry() {
    }

    public static List<NodeReader> getNodeReaders(URL url) {
        ArrayList<NodeReader> list = new ArrayList<NodeReader>();
        for (NodeReaderProvider spi : ServiceLoader.load(NodeReaderProvider.class)) {
            if (!spi.canDecodeInput(url)) continue;
            list.add(spi.createReader());
        }
        return list;
    }

    public static List<NodeReader> getNodeReaders(String path) {
        ArrayList<NodeReader> list = new ArrayList<NodeReader>();
        for (NodeReaderProvider spi : ServiceLoader.load(NodeReaderProvider.class)) {
            if (!spi.canDecodeInput(path)) continue;
            list.add(spi.createReader());
        }
        return list;
    }

    public static @Nullable NodeReader getNodeReader(URL url) {
        List<NodeReader> list = NodeReaderRegistry.getNodeReaders(url);
        return list.isEmpty() ? null : list.getFirst();
    }

    public static @Nullable NodeReader getNodeReader(String path) {
        List<NodeReader> list = NodeReaderRegistry.getNodeReaders(path);
        return list.isEmpty() ? null : list.getFirst();
    }
}

