/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.styleable;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.css.StyleOrigin;
import org.jhotdraw8.fxbase.styleable.SimpleStyleableMapProxy;
import org.jhotdraw8.fxbase.styleable.StyleableMap;
import org.jspecify.annotations.Nullable;

public class SimpleStyleableMap<K, V>
extends AbstractMap<K, V>
implements StyleableMap<K, V> {
    private static final Object NULL_VALUE = new Object();
    private static final Object NO_VALUE = null;
    private static final int numOrigins = 4;
    private static final int numOriginsMask = 3;
    private @Nullable CopyOnWriteArrayList<MapChangeListener<? super K, ? super V>> changeListenerList;
    private @Nullable CopyOnWriteArrayList<InvalidationListener> invalidationListenerList;
    private final Map<K, Integer> keyMap;
    private final StyleOrigin origin;
    private final int originOrdinal;
    private final int[] sizes;
    private Object[] values;
    private final SimpleStyleableMap<K, V> originalMap;
    static final int AUTO_ORIGIN = -StyleOrigin.INLINE.ordinal();

    @Override
    public Set<Map.Entry<K, V>> entrySet(@Nullable StyleOrigin origin) {
        return new EntrySet(origin);
    }

    public SimpleStyleableMap() {
        this(new HashMap<K, Integer>(){
            private static final long serialVersionUID = 0L;

            @Override
            public Integer get(Object key) {
                return super.computeIfAbsent(key, k1 -> this.size());
            }
        });
    }

    public SimpleStyleableMap(Map<K, Integer> keyMap) {
        this.keyMap = keyMap;
        this.values = new Object[keyMap.size() * 4];
        this.origin = StyleOrigin.USER;
        this.originOrdinal = this.origin.ordinal();
        this.sizes = new int[4];
        this.originalMap = this;
    }

    public void addListener(InvalidationListener listener) {
        if (this.originalMap.invalidationListenerList == null) {
            this.originalMap.invalidationListenerList = new CopyOnWriteArrayList();
        }
        this.originalMap.invalidationListenerList.add(listener);
    }

    public void addListener(MapChangeListener<? super K, ? super V> observer) {
        if (this.originalMap.changeListenerList == null) {
            this.originalMap.changeListenerList = new CopyOnWriteArrayList();
        }
        this.originalMap.changeListenerList.add(observer);
    }

    protected void callObservers(StyleOrigin origin, MapChangeListener.Change<K, V> change) {
        if (origin == StyleOrigin.USER && this.originalMap.changeListenerList != null) {
            for (MapChangeListener<? super K, ? super V> mapChangeListener : this.originalMap.changeListenerList) {
                mapChangeListener.onChanged(change);
            }
        }
        if (this.originalMap.invalidationListenerList != null) {
            for (InvalidationListener invalidationListener : this.originalMap.invalidationListenerList) {
                invalidationListener.invalidated((Observable)this);
            }
        }
    }

    @Override
    public void clear() {
        this.removeAll(this.origin);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(this.origin, key);
    }

    @Override
    public <T extends K> boolean containsKey(@Nullable StyleOrigin origin, T key) {
        Integer index = this.keyMap.get(key);
        if (origin == null) {
            return this.getStyleOrigin(key) != null;
        }
        if (index != null && index * 4 + origin.ordinal() < this.values.length) {
            Object rawValue = this.values[index * 4 + origin.ordinal()];
            return rawValue != NO_VALUE;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(this.origin, value);
    }

    public boolean containsValue(StyleOrigin origin, @Nullable Object value) {
        if (value == null) {
            value = NULL_VALUE;
        }
        int n = this.values.length;
        for (int i = origin.ordinal(); i < n; i += 4) {
            if (!Objects.equals(this.values[i], value)) continue;
            return true;
        }
        return false;
    }

    private int ensureCapacity(K key) {
        Integer indexNullable = this.keyMap.get(key);
        if (indexNullable == null) {
            throw new UnsupportedOperationException("Could not retrieve key " + String.valueOf(key) + " from keyMap: " + String.valueOf(this.keyMap));
        }
        int index = indexNullable;
        int minCapacity = (1 + index) * 4;
        if (this.values.length < minCapacity) {
            int newCapacity = this.nextPowerOfTwoUp(1 + index) * 4;
            this.values = Arrays.copyOf(this.values, Integer.max(this.values.length, newCapacity));
        }
        return index;
    }

    private int nextPowerOfTwoUp(int value) {
        Objects.checkIndex(value, 0x20000000);
        int highestOneBit = Integer.highestOneBit(value);
        return value == highestOneBit ? value : highestOneBit << 1;
    }

    private int indexIfPresent(K key) {
        Integer index = this.keyMap.get(key);
        return index == null ? -1 : index;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(null);
    }

    @Override
    public @Nullable V get(Object key) {
        return this.getOrDefault(this.originOrdinal, key, null);
    }

    @Override
    public @Nullable V getOrDefault(Object key, @Nullable V defaultValue) {
        return this.getOrDefault(this.originOrdinal, key, defaultValue);
    }

    @Override
    public @Nullable V get(StyleOrigin origin, K key) {
        return this.getOrDefault(origin.ordinal(), key, null);
    }

    public @Nullable V getOrDefault(StyleOrigin origin, K key, @Nullable V defaultValue) {
        return this.getOrDefault(origin.ordinal(), key, null);
    }

    protected @Nullable V getOrDefault(int originOrdinal, Object key, @Nullable V defaultValue) {
        Integer index = this.keyMap.get(key);
        return index == null ? defaultValue : this.getValue(originOrdinal, index, key, defaultValue);
    }

    @Override
    public Map<K, V> getMap(StyleOrigin origin) {
        return origin == this.origin ? this : new SimpleStyleableMapProxy(this, origin);
    }

    @Override
    public @Nullable StyleOrigin getStyleOrigin(K key) {
        Integer indexNullable = this.keyMap.get(key);
        if (indexNullable == null) {
            return null;
        }
        int index = indexNullable;
        for (int i = 3; i >= 0; --i) {
            Object value;
            int arrayIndex = index * 4 + i;
            Object object = value = arrayIndex < this.values.length ? this.values[arrayIndex] : null;
            if (value == null) continue;
            return StyleOrigin.values()[i];
        }
        return null;
    }

    @Override
    public V removeKey(StyleOrigin origin, K key) {
        Object oldRawValue = this.setRawValue(origin.ordinal(), this.ensureCapacity(key), key, NO_VALUE);
        return this.rawValueToValue(oldRawValue);
    }

    @Override
    public Map<K, V> getStyledMap() {
        return new SimpleStyleableMapProxy(this, null);
    }

    private @Nullable V getValue(int index, K key) {
        return this.getValue(this.originOrdinal, index, key, null);
    }

    private @Nullable V getValue(int ordinal, int index, K key, V defaultValue) {
        Object rawValue = this.getRawValue(ordinal, index);
        return rawValue == NO_VALUE ? defaultValue : this.rawValueToValue(rawValue);
    }

    private @Nullable Object getRawValue(int ordinal, int index) {
        Object value;
        if (ordinal < 0) {
            value = null;
            if (index * 4 < this.values.length) {
                int valueIndex;
                for (int i = -ordinal; i >= 0 && (value = this.values[valueIndex = index * 4 + i]) == NO_VALUE; --i) {
                }
            }
        } else {
            int arrayIndex = index * 4 + ordinal;
            value = arrayIndex < this.values.length ? this.values[arrayIndex] : NO_VALUE;
        }
        return value;
    }

    private boolean hasValue(int index) {
        return this.hasValue(this.originOrdinal, index);
    }

    private boolean hasValue(int ordinal, int index) {
        return this.getRawValue(ordinal, index) != NO_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.sizes[this.originOrdinal] == 0;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public @Nullable V put(K key, V value) {
        int index = this.ensureCapacity(key);
        return this.setValue(this.originOrdinal, index, key, value);
    }

    @Override
    public @Nullable V put(StyleOrigin styleOrigin, K key, V value) {
        return this.put(styleOrigin.ordinal(), key, value);
    }

    protected @Nullable V put(int originOrdinal, K key, V value) {
        int index = this.ensureCapacity(key);
        return this.setValue(originOrdinal, index, key, value);
    }

    @Override
    public @Nullable V remove(Object key) {
        int index = this.indexIfPresent(key);
        return index < 0 ? null : (V)this.removeValue(this.originOrdinal, index, key);
    }

    @Override
    public void removeAll(StyleOrigin origin) {
        if (origin == StyleOrigin.USER) {
            int ordinal = origin.ordinal();
            for (Map.Entry<K, Integer> e : this.keyMap.entrySet()) {
                Integer index = e.getValue();
                if (index >= this.values.length) continue;
                this.removeValue(ordinal, index, e.getKey());
            }
        } else {
            int ordinal = origin.ordinal();
            int n = this.values.length;
            for (int i = 0; i < n; ++i) {
                if ((i & 3) != ordinal) continue;
                this.values[i] = NO_VALUE;
            }
        }
    }

    @Override
    public void resetStyledValues() {
        int n = this.values.length;
        for (int i = 0; i < n; i += 4) {
            this.values[i] = NO_VALUE;
            this.values[i + 2] = NO_VALUE;
            this.values[i + 3] = NO_VALUE;
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.originalMap.invalidationListenerList != null) {
            this.originalMap.invalidationListenerList.remove(listener);
        }
    }

    public void removeListener(MapChangeListener<? super K, ? super V> observer) {
        if (this.originalMap.changeListenerList != null) {
            this.originalMap.changeListenerList.remove(observer);
        }
    }

    private @Nullable V removeValue(int ordinal, int index, K key) {
        Object oldRawValue;
        if (ordinal < 0) {
            throw new UnsupportedOperationException("can not remove styled value");
        }
        int arrayIndex = index * 4 + ordinal;
        Object object = oldRawValue = arrayIndex < this.values.length ? this.values[arrayIndex] : NO_VALUE;
        if (oldRawValue == NO_VALUE) {
            return null;
        }
        this.values[index * 4 + ordinal] = null;
        int n = ordinal;
        this.sizes[n] = this.sizes[n] - 1;
        V oldValue = this.rawValueToValue(oldRawValue);
        if (this.origin == StyleOrigin.USER) {
            ChangeEvent change = new ChangeEvent(this, key, oldValue, null, false, true);
            this.callObservers(this.origin, change);
        }
        return oldValue;
    }

    private @Nullable V setValue(int ordinal, int index, K key, @Nullable V newValue) {
        Object oldRawValue = this.setRawValue(ordinal, index, key, newValue == null ? NULL_VALUE : newValue);
        return this.rawValueToValue(oldRawValue);
    }

    private @Nullable V rawValueToValue(@Nullable Object rawValue) {
        return (V)(rawValue == NULL_VALUE || rawValue == NO_VALUE ? null : rawValue);
    }

    private Object setRawValue(int ordinal, int keyIndex, K key, @Nullable Object newRawValue) {
        if (ordinal < 0) {
            throw new UnsupportedOperationException("can not set styled value");
        }
        int valueIndex = keyIndex * 4 + ordinal;
        Object oldRawValue = this.values[valueIndex];
        if (oldRawValue == NO_VALUE) {
            int n = ordinal;
            this.sizes[n] = this.sizes[n] + 1;
        }
        if (newRawValue == NO_VALUE) {
            int n = ordinal;
            this.sizes[n] = this.sizes[n] - 1;
        }
        this.values[valueIndex] = newRawValue;
        if (!Objects.equals(oldRawValue, newRawValue) && ordinal == StyleOrigin.USER.ordinal()) {
            boolean wasRemoved;
            V newValue = this.rawValueToValue(newRawValue);
            V oldValue = this.rawValueToValue(oldRawValue);
            boolean wasAdded = newRawValue != NO_VALUE;
            boolean bl = wasRemoved = oldRawValue != NO_VALUE;
            if (!Objects.equals(oldValue, newValue)) {
                ChangeEvent change = new ChangeEvent(this, key, oldValue, newValue, wasAdded, wasRemoved);
                this.callObservers(this.origin, change);
            }
        }
        return oldRawValue;
    }

    public int getIdentityHash() {
        return System.identityHashCode(this.values);
    }

    @Override
    public int size() {
        return this.sizes[this.originOrdinal];
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    public int size(@Nullable StyleOrigin origin) {
        if (origin == null) {
            return this.sizes[this.originOrdinal];
        }
        return this.sizes[origin.ordinal()];
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final @Nullable StyleOrigin origin;
        private final int originOrdinal;

        public EntrySet(StyleOrigin origin) {
            this.origin = origin;
            this.originOrdinal = origin == null ? AUTO_ORIGIN : origin.ordinal();
        }

        @Override
        public void clear() {
            SimpleStyleableMap.this.clear();
        }

        @Override
        public int size() {
            return SimpleStyleableMap.this.size(this.origin);
        }

        @Override
        public boolean isEmpty() {
            return SimpleStyleableMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleStyleableMap.this.containsKey(this.origin, e.getKey()) && Objects.equals(SimpleStyleableMap.this.get(this.origin, e.getKey()), e.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<K, Integer>> entryIt;
                private boolean hasNext;
                private K nextKey;
                private K lastKey;
                private int nextValue;
                private int lastValue;
                {
                    this.entryIt = SimpleStyleableMap.this.keyMap.entrySet().iterator();
                    this.advance();
                }

                private void advance() {
                    while (this.entryIt.hasNext()) {
                        Map.Entry entry = this.entryIt.next();
                        if (!SimpleStyleableMap.this.hasValue(EntrySet.this.originOrdinal, entry.getValue())) continue;
                        this.nextKey = entry.getKey();
                        this.nextValue = entry.getValue();
                        this.hasNext = true;
                        return;
                    }
                    this.hasNext = false;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public Map.Entry<K, V> next() {
                    this.lastKey = this.nextKey;
                    this.lastValue = this.nextValue;
                    this.advance();
                    return new MapEntry(this.lastKey, this.lastValue, SimpleStyleableMap.this.originOrdinal);
                }

                @Override
                public void remove() {
                    SimpleStyleableMap.this.removeValue(SimpleStyleableMap.this.originOrdinal, this.lastValue, this.lastKey);
                }
            };
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            boolean added;
            boolean bl = added = !SimpleStyleableMap.this.containsKey(e.getKey()) || Objects.equals(SimpleStyleableMap.this.get(e.getKey()), e.getValue());
            if (added) {
                SimpleStyleableMap.this.put(e.getKey(), e.getValue());
            }
            return added;
        }

        @Override
        public boolean remove(Object o) {
            boolean removed;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            boolean bl = removed = SimpleStyleableMap.this.containsKey(e.getKey()) && Objects.equals(SimpleStyleableMap.this.get(e.getKey()), e.getValue());
            if (removed) {
                SimpleStyleableMap.this.remove(e.getKey());
            }
            return removed;
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return SimpleStyleableMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SimpleStyleableMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return SimpleStyleableMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                private final Iterator<Map.Entry<K, Integer>> entryIt;
                private boolean hasNext;
                private K nextKey;
                private K lastKey;
                {
                    this.entryIt = SimpleStyleableMap.this.keyMap.entrySet().iterator();
                    this.advance();
                }

                private void advance() {
                    while (this.entryIt.hasNext()) {
                        Map.Entry entry = this.entryIt.next();
                        if (!SimpleStyleableMap.this.hasValue(entry.getValue())) continue;
                        this.nextKey = entry.getKey();
                        this.hasNext = true;
                        return;
                    }
                    this.hasNext = false;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public K next() {
                    this.lastKey = this.nextKey;
                    this.advance();
                    return this.lastKey;
                }

                @Override
                public void remove() {
                    SimpleStyleableMap.this.remove(this.lastKey);
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            boolean removed = SimpleStyleableMap.this.containsKey(o);
            if (removed) {
                SimpleStyleableMap.this.remove(o);
            }
            return removed;
        }

        @Override
        public void clear() {
            SimpleStyleableMap.this.clear();
        }
    }

    private class ChangeEvent
    extends MapChangeListener.Change<K, V> {
        private final K key;
        private final V old;
        private final V added;
        private final boolean wasAdded;
        private final boolean wasRemoved;

        public ChangeEvent(SimpleStyleableMap simpleStyleableMap, K key, V old, V added, boolean wasAdded, boolean wasRemoved) {
            super((ObservableMap)simpleStyleableMap);
            assert (wasAdded || wasRemoved);
            this.key = key;
            this.old = old;
            this.added = added;
            this.wasAdded = wasAdded;
            this.wasRemoved = wasRemoved;
        }

        public String toString() {
            return "ChangeEvent{key=" + String.valueOf(this.key) + ", old=" + String.valueOf(this.old) + ", added=" + String.valueOf(this.added) + ", wasAdded=" + this.wasAdded + ", wasRemoved=" + this.wasRemoved + "}";
        }

        public boolean wasAdded() {
            return this.wasAdded;
        }

        public boolean wasRemoved() {
            return this.wasRemoved;
        }

        public K getKey() {
            return this.key;
        }

        public V getValueAdded() {
            return this.added;
        }

        public V getValueRemoved() {
            return this.old;
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        @Override
        public int size() {
            return SimpleStyleableMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SimpleStyleableMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return SimpleStyleableMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private final Iterator<Map.Entry<K, Integer>> entryIt;
                private boolean hasNext;
                private K nextKey;
                private K lastKey;
                private @Nullable V nextValue;
                private @Nullable V lastValue;
                {
                    this.entryIt = SimpleStyleableMap.this.keyMap.entrySet().iterator();
                    this.advance();
                }

                private void advance() {
                    while (this.entryIt.hasNext()) {
                        Map.Entry entry = this.entryIt.next();
                        if (!SimpleStyleableMap.this.hasValue(entry.getValue())) continue;
                        this.nextKey = entry.getKey();
                        this.nextValue = SimpleStyleableMap.this.getValue(entry.getValue(), this.nextKey);
                        this.hasNext = true;
                        return;
                    }
                    this.hasNext = false;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public @Nullable V next() {
                    this.lastKey = this.nextKey;
                    this.lastValue = this.nextValue;
                    this.advance();
                    return this.lastValue;
                }

                @Override
                public void remove() {
                    SimpleStyleableMap.this.remove(this.lastKey);
                }
            };
        }

        @Override
        public void clear() {
            SimpleStyleableMap.this.clear();
        }
    }

    private class MapEntry
    implements Map.Entry<K, V> {
        private final K key;
        private final int index;
        private final int originOrdinal;

        public MapEntry(K key, int index, int originOrdinal) {
            this.key = key;
            this.index = index;
            this.originOrdinal = originOrdinal;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public @Nullable V getValue() {
            return SimpleStyleableMap.this.getValue(this.originOrdinal, this.index, this.key, null);
        }

        @Override
        public @Nullable V setValue(V value) {
            Object oldValue = SimpleStyleableMap.this.getValue(this.originOrdinal, this.index, this.key, null);
            SimpleStyleableMap.this.setValue(this.originOrdinal, this.index, this.key, value);
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            if (Objects.equals(k1, k2 = e.getKey())) {
                Object v1 = this.getValue();
                Object v2 = e.getValue();
                return Objects.equals(v1, v2);
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public final @Nullable String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }
}

