/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.tree;

import org.jhotdraw8.fxbase.tree.TreeNode;
import org.jhotdraw8.fxcollection.indexedset.AbstractIndexedArrayObservableSet;

public class ChildList<E extends TreeNode<E>>
extends AbstractIndexedArrayObservableSet<E> {
    private final E parent;

    public ChildList(E parent) {
        this.parent = parent;
    }

    protected Boolean onContains(E e) {
        return e.getParent() == this.parent;
    }

    protected void onAdded(E e) {
        Object oldParent = e.getParent();
        if (oldParent != null && oldParent != this.parent) {
            oldParent.getChildren().remove(e);
        }
        e.setParent(this.parent);
    }

    protected void onRemoved(E e) {
        e.setParent(null);
    }

    protected boolean mayBeAdded(E element) {
        return this.parent.isSuitableChild(element) && element.isSuitableParent(this.parent);
    }
}

