/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.tree;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.function.Supplier;
import javafx.scene.control.TreeItem;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.fxbase.tree.AbstractTreePresentationModel;
import org.jhotdraw8.fxbase.tree.TreeModel;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;
import org.jspecify.annotations.Nullable;

public class SimpleTreePresentationModel<N>
extends AbstractTreePresentationModel<N> {
    private final Map<N, TreeItem<N>> items;
    private final Listener<TreeModelEvent<N>> modelHandler = new Listener<TreeModelEvent<N>>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handle(TreeModelEvent<N> event) {
            ++SimpleTreePresentationModel.this.updating;
            try {
                Object f = event.getNode();
                switch (event.getEventType()) {
                    case NODE_ADDED_TO_PARENT: {
                        SimpleTreePresentationModel.this.onNodeAdded(f, event.getParent(), event.getChildIndex());
                        return;
                    }
                    case NODE_REMOVED_FROM_PARENT: {
                        SimpleTreePresentationModel.this.onNodeRemoved(f, event.getParent(), event.getChildIndex());
                        return;
                    }
                    case NODE_ADDED_TO_TREE: {
                        SimpleTreePresentationModel.this.onNodeAddedToTree(f, event.getParent(), event.getChildIndex());
                        return;
                    }
                    case NODE_REMOVED_FROM_TREE: {
                        SimpleTreePresentationModel.this.onNodeRemovedFromTree(f);
                        return;
                    }
                    case NODE_CHANGED: {
                        SimpleTreePresentationModel.this.onNodeInvalidated(f);
                        return;
                    }
                    case ROOT_CHANGED: {
                        SimpleTreePresentationModel.this.onRootChanged();
                        return;
                    }
                    case SUBTREE_NODES_CHANGED: {
                        return;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.valueOf((Object)event.getEventType()) + " not supported");
                    }
                }
            }
            finally {
                --SimpleTreePresentationModel.this.updating;
            }
        }
    };
    private final boolean reversed = true;
    private final TreeItem<N> root = new LazyTreeItem<Object>(null);
    protected int updating;

    public SimpleTreePresentationModel(Supplier<Map<N, TreeItem<N>>> mapFactory) {
        this.items = mapFactory.get();
    }

    @Override
    public TreeItem<N> getRoot() {
        return this.root;
    }

    @Override
    public TreeItem<N> getTreeItem(N f) {
        return this.items.get(f);
    }

    public N getValue(TreeItem<N> item) {
        return (N)item.getValue();
    }

    protected void onNodeAdded(N node, N parentE, int index) {
        TreeItem item = this.items.computeIfAbsent(node, TreeItem::new);
        TreeItem<N> parentItem = this.items.get(parentE);
        if (parentItem == null) {
            return;
        }
        parentItem.getChildren().add(parentItem.getChildren().size() - index, (Object)item);
    }

    protected void onNodeAddedToTree(N node, N parent, int index) {
        TreeModel<N> m = this.getTreeModel();
        LazyTreeItem<N> item = new LazyTreeItem<N>(node);
        item.setExpanded(false);
        this.items.put(node, item);
        int childIndex = 0;
        ArrayDeque<TreeItem> deque = new ArrayDeque<TreeItem>();
        int n = m.getChildCount(node);
        for (int i = 0; i < n; ++i) {
            Object child = m.getChild(node, i);
            this.onNodeAddedToTree(child, node, childIndex);
            TreeItem childItem = this.items.computeIfAbsent(child, TreeItem::new);
            deque.addFirst(childItem);
            ++childIndex;
        }
        item.getChildren().addAll(deque);
    }

    protected void onNodeInvalidated(N f) {
        TreeItem<N> node = this.items.get(f);
        if (node != null) {
            node.setValue(f);
        }
    }

    protected void onNodeRemoved(N f, N parentE, int index) {
        TreeItem<N> parent = this.items.get(parentE);
        parent.getChildren().remove(parent.getChildren().size() - 1 - index);
    }

    protected void onNodeRemovedFromTree(N f) {
        this.items.remove(f);
    }

    protected void onRootChanged() {
        TreeModel m = this.getTreeModel();
        Object modelRoot = m.getRoot();
        this.root.setValue(modelRoot);
        this.root.getChildren().clear();
        this.items.clear();
        this.items.put(modelRoot, this.root);
        int childIndex = 0;
        if (modelRoot != null) {
            int n = m.getChildCount(modelRoot);
            for (int i = 0; i < n; ++i) {
                Object child = m.getChild(modelRoot, i);
                this.onNodeAddedToTree(child, modelRoot, childIndex);
                this.onNodeAdded(child, modelRoot, childIndex);
                ++childIndex;
            }
        }
    }

    @Override
    protected void onTreeModelChanged(@Nullable TreeModel<N> oldValue, TreeModel<N> newValue) {
        if (oldValue != null) {
            oldValue.removeTreeModelListener(this.modelHandler);
        }
        newValue.addTreeModelListener(this.modelHandler);
        this.onRootChanged();
    }

    @Override
    public boolean isUpdating() {
        return this.updating > 0;
    }

    private static class LazyTreeItem<N>
    extends TreeItem<N> {
        public LazyTreeItem(N value) {
            super(value);
        }
    }
}

