/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.tree;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.fxbase.beans.ObservableMixin;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;
import org.jspecify.annotations.Nullable;

public interface TreeModel<N>
extends ObservableMixin {
    public static final String ROOT_PROPERTY = "root";

    public CopyOnWriteArrayList<Listener<TreeModelEvent<N>>> getTreeModelListeners();

    @Override
    public CopyOnWriteArrayList<InvalidationListener> getInvalidationListeners();

    public ObjectProperty<N> rootProperty();

    default public void addTreeModelListener(Listener<TreeModelEvent<N>> l) {
        this.getTreeModelListeners().add(l);
    }

    default public void removeTreeModelListener(Listener<TreeModelEvent<N>> l) {
        this.getTreeModelListeners().remove(l);
    }

    default public @Nullable N getRoot() {
        return (N)this.rootProperty().get();
    }

    default public void setRoot(@Nullable N root) {
        this.rootProperty().set(root);
    }

    public List<N> getChildren(N var1);

    public int getChildCount(N var1);

    public N getChild(N var1, int var2);

    public void removeFromParent(N var1);

    public void insertChildAt(N var1, N var2, int var3);

    default public void addChildTo(N child, N parent) {
        this.insertChildAt(child, parent, this.getChildCount(parent));
    }

    default public void fireTreeModelEvent(TreeModelEvent<N> event) {
        for (Listener<TreeModelEvent<N>> l : this.getTreeModelListeners()) {
            l.handle(event);
        }
    }

    default public void fireNodeInvalidated(N node) {
        this.fireTreeModelEvent(TreeModelEvent.nodeChanged(this, node));
    }
}

