/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.tree;

import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;
import org.jhotdraw8.fxbase.text.ResourceBundleStub;
import org.jhotdraw8.fxbase.tree.TreeModel;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;
import org.jspecify.annotations.Nullable;

public class TreeModelUndoAdapter<E> {
    public static final String RESOURCE_BUNDLE_PROPERTY = "resourceBundle";
    private final CopyOnWriteArrayList<UndoableEditListener> listeners = new CopyOnWriteArrayList();
    private final Listener<TreeModelEvent<E>> treeModelListener = event -> {
        AbstractUndoableEdit edit;
        switch (event.getEventType()) {
            default: {
                throw new MatchException(null, null);
            }
            case ROOT_CHANGED: {
                AbstractUndoableEdit abstractUndoableEdit = new RootChangedEdit((TreeModel)event.getSource(), event.getOldRoot(), event.getNewRoot());
                break;
            }
            case SUBTREE_NODES_CHANGED: 
            case NODE_ADDED_TO_TREE: 
            case NODE_REMOVED_FROM_TREE: 
            case NODE_CHANGED: {
                AbstractUndoableEdit abstractUndoableEdit = null;
                break;
            }
            case NODE_ADDED_TO_PARENT: {
                AbstractUndoableEdit abstractUndoableEdit = new NodeAddedEdit((TreeModel)event.getSource(), event.getParent(), event.getChildIndex(), event.getChild());
                break;
            }
            case NODE_REMOVED_FROM_PARENT: {
                AbstractUndoableEdit abstractUndoableEdit = edit = new NodeRemovedEdit((TreeModel)event.getSource(), event.getParent(), event.getChildIndex(), event.getChild());
            }
        }
        if (edit != null) {
            this.fireUndoableEdit(event.getSource(), edit);
        }
    };
    private final NonNullObjectProperty<ResourceBundle> resourceBundle = new NonNullObjectProperty<ResourceBundleStub>(this, "resourceBundle", new ResourceBundleStub());

    public TreeModelUndoAdapter() {
    }

    public TreeModelUndoAdapter(TreeModel<E> model) {
        this.bind(model);
    }

    public void addUndoEditListener(UndoableEditListener listener) {
        this.listeners.add(listener);
    }

    public void bind(TreeModel<E> model) {
        this.unbind(model);
        model.addTreeModelListener(this.treeModelListener);
    }

    protected void fireUndoableEdit(Object source, UndoableEdit edit) {
        UndoableEditEvent editEvent = new UndoableEditEvent(source, edit);
        this.listeners.forEach(e -> e.undoableEditHappened(editEvent));
    }

    public ResourceBundle getResourceBundle() {
        return (ResourceBundle)this.resourceBundle.get();
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle.set(resourceBundle);
    }

    public void removeUndoEditListener(UndoableEditListener listener) {
        this.listeners.remove(listener);
    }

    public NonNullObjectProperty<ResourceBundle> resourceBundleProperty() {
        return this.resourceBundle;
    }

    public void unbind(TreeModel<E> model) {
        model.removeTreeModelListener(this.treeModelListener);
    }

    class RootChangedEdit<EE>
    extends AbstractUndoableEdit {
        private final TreeModel<EE> model;
        private final @Nullable EE oldRoot;
        private final @Nullable EE newRoot;

        public RootChangedEdit(@Nullable TreeModel<EE> model, @Nullable EE oldRoot, EE newRoot) {
            this.model = model;
            this.oldRoot = oldRoot;
            this.newRoot = newRoot;
        }

        @Override
        public String getPresentationName() {
            return TreeModelUndoAdapter.this.getResourceBundle().getString("edit.addElement");
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.setRoot(this.newRoot);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.setRoot(this.oldRoot);
        }
    }

    class NodeAddedEdit<EE>
    extends AbstractUndoableEdit {
        private final TreeModel<EE> model;
        private final EE parent;
        private final int childIndex;
        private final EE child;

        public NodeAddedEdit(TreeModel<EE> model, EE parent, int childIndex, EE child) {
            this.model = model;
            this.parent = parent;
            this.childIndex = childIndex;
            this.child = child;
        }

        @Override
        public String getPresentationName() {
            return TreeModelUndoAdapter.this.getResourceBundle().getString("edit.addElement");
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.insertChildAt(this.child, this.parent, this.childIndex);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.removeFromParent(this.child);
        }
    }

    class NodeRemovedEdit<EE>
    extends AbstractUndoableEdit {
        private final TreeModel<EE> model;
        private final EE parent;
        private final int childIndex;
        private final EE child;

        public NodeRemovedEdit(TreeModel<EE> model, EE parent, int childIndex, EE child) {
            this.model = model;
            this.parent = parent;
            this.childIndex = childIndex;
            this.child = child;
        }

        @Override
        public String getPresentationName() {
            return TreeModelUndoAdapter.this.getResourceBundle().getString("edit.removeElement");
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.removeFromParent(this.child);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.insertChildAt(this.child, this.parent, this.childIndex);
        }
    }
}

