/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.tree;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import org.jhotdraw8.collection.spliterator.SpliteratorIterable;
import org.jhotdraw8.fxbase.tree.PostorderSpliterator;
import org.jhotdraw8.fxbase.tree.PreorderSpliterator;
import org.jhotdraw8.fxbase.tree.TreeBreadthFirstSpliterator;
import org.jhotdraw8.fxbase.tree.TreeDepthFirstSpliterator;
import org.jhotdraw8.fxbase.tree.TreeMaxDepthCalculator;
import org.jspecify.annotations.Nullable;

public interface TreeNode<T extends TreeNode<T>> {
    default public Iterable<T> ancestorIterable() {
        Iterable i = () -> new AncestorIterator<TreeNode>(this);
        return i;
    }

    default public Iterable<T> breadthFirstIterable() {
        return new SpliteratorIterable(() -> {
            TreeNode t = this;
            return new TreeBreadthFirstSpliterator<TreeNode>(TreeNode::getChildren, t);
        });
    }

    default public void dumpTree() {
        try {
            this.dumpTree(System.out, 0);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    default public void dumpTree(Appendable out, int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            out.append('.');
        }
        out.append(this.toString());
        out.append('\n');
        for (TreeNode child : this.getChildren()) {
            child.dumpTree(out, depth + 1);
        }
    }

    default public <TT> @Nullable TT getAncestor(Class<TT> ancestorType) {
        TreeNode<T> ancestor;
        for (ancestor = this; ancestor != null && !ancestorType.isInstance(ancestor); ancestor = ancestor.getParent()) {
        }
        TreeNode temp = ancestor;
        return (TT)temp;
    }

    default public T getChild(int index) {
        return (T)((TreeNode)this.getChildren().get(index));
    }

    public List<T> getChildren();

    default public @Nullable T getFirstChild() {
        return (T)(this.getChildren().isEmpty() ? null : (TreeNode)this.getChildren().getLast());
    }

    default public @Nullable T getLastChild() {
        return (T)(this.getChildren().isEmpty() ? null : (TreeNode)this.getChildren().getFirst());
    }

    public @Nullable T getParent();

    public void setParent(@Nullable T var1);

    default public List<T> getPath() {
        LinkedList<TreeNode> path = new LinkedList<TreeNode>();
        for (TreeNode<T> node = this; node != null; node = node.getParent()) {
            path.addFirst(node);
        }
        return path;
    }

    default public int getDepth() {
        int depth = 0;
        for (T node = this.getParent(); node != null; node = node.getParent()) {
            ++depth;
        }
        return depth;
    }

    default public Iterable<T> postorderIterable() {
        return new SpliteratorIterable(() -> {
            TreeNode t = this;
            return new PostorderSpliterator<TreeNode>(TreeNode::getChildren, t);
        });
    }

    default public Iterable<T> depthFirstIterable() {
        return new SpliteratorIterable(() -> {
            TreeNode t = this;
            return new TreeDepthFirstSpliterator<TreeNode>(TreeNode::getChildren, t);
        });
    }

    default public Iterable<T> preorderIterable() {
        return new SpliteratorIterable(() -> {
            TreeNode t = this;
            return new PreorderSpliterator<TreeNode>(TreeNode::getChildren, t);
        });
    }

    default public Spliterator<T> preorderSpliterator() {
        TreeNode t = this;
        return new PreorderSpliterator<TreeNode>(TreeNode::getChildren, t);
    }

    default public int getMaxDepth() {
        return new TreeMaxDepthCalculator().getMaxDepth(this, TreeNode::getChildren);
    }

    default public boolean isSuitableParent(T newParent) {
        return true;
    }

    default public boolean isSuitableChild(T newChild) {
        return true;
    }

    public static class AncestorIterator<T extends TreeNode<T>>
    implements Iterator<T> {
        private @Nullable T node;

        private AncestorIterator(@Nullable T node) {
            this.node = node;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public @Nullable T next() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            T next = this.node;
            this.node = this.node.getParent();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

