/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.undo;

import java.util.function.Consumer;
import javax.swing.event.UndoableEditEvent;
import org.jhotdraw8.fxbase.undo.CompositeEdit;
import org.jspecify.annotations.Nullable;

public class UndoableEditHelper {
    private @Nullable CompositeEdit edit;
    private final Consumer<UndoableEditEvent> handler;
    private final Object source;

    public UndoableEditHelper(Object source, Consumer<UndoableEditEvent> handler) {
        this.handler = handler;
        this.source = source;
    }

    public void startCompositeEdit(@Nullable String localizedName) {
        if (this.edit == null) {
            this.edit = new CompositeEdit(localizedName);
            this.fire(this.edit);
        }
    }

    private void fire(CompositeEdit edit) {
        new UndoableEditEvent(this.source, edit);
    }

    public void stopCompositeEdit() {
        if (this.edit != null) {
            this.fire(this.edit);
            this.edit = null;
        }
    }
}

