/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection.precondition;

import org.jhotdraw8.annotation.NonNull;

public class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression, @NonNull String errorMessageTemplate, Object ... arguments) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, arguments));
        }
    }

    public static int checkValueInRange(int value, int min, int max, String name) {
        if (value < min || value >= max) {
            throw new IllegalArgumentException(name + ": " + value + " not in range: [" + min + ", " + max + "].");
        }
        return value;
    }

    public static int checkIndex(int index, int length) {
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("index: " + index + " not in range: [0, " + length + ").");
        }
        return index;
    }

    public static int checkFromToIndex(int from, int to, int length) {
        if (from < 0 || from > to || to > length) {
            throw new IndexOutOfBoundsException("sub-range: [" + from + ", " + to + ") not in range: [0, " + length + ").");
        }
        return from;
    }

    public static int checkFromIndexSize(int from, int size, int length) {
        if (from < 0 || size < 0 || from + size > length) {
            throw new IndexOutOfBoundsException("sub-range: [" + from + ", " + (from + size) + ") not in range: [0, " + length + ").");
        }
        return from;
    }
}

