/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection.typesafekey;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import javafx.beans.binding.Binding;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableMap;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxcollection.typesafekey.KeyMapEntryProperty;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;

public interface Key<T>
extends MapAccessor<T> {
    public static final long serialVersionUID = 1L;

    @Override
    default public boolean containsKey(@NonNull Map<Key<?>, Object> map) {
        return map.containsKey(this);
    }

    @Override
    default public @Nullable T get(@NonNull Map<? super Key<?>, Object> a) {
        Object result = a.getOrDefault(this, this.getDefaultValue());
        return (T)result;
    }

    @Override
    default public @Nullable T get(@NonNull ReadOnlyMap<? super Key<?>, Object> a) {
        Object result = a.getOrDefault((Object)this, this.getDefaultValue());
        return (T)result;
    }

    default public @NonNull ObjectProperty<T> getValueProperty(@NonNull Map<? super Key<?>, ObjectProperty<?>> a) {
        if (!a.containsKey(this)) {
            a.put(this, (ObjectProperty<?>)new SimpleObjectProperty(this.getDefaultValue()));
        }
        SimpleObjectProperty value = (SimpleObjectProperty)a.get(this);
        return value;
    }

    default public @Nullable T getValue(@NonNull Map<? super Key<?>, ObjectProperty<?>> a) {
        if (!a.containsKey(this)) {
            a.put(this, (ObjectProperty<?>)new SimpleObjectProperty(this.getDefaultValue()));
        }
        SimpleObjectProperty value = (SimpleObjectProperty)a.get(this);
        return (T)value.get();
    }

    @Override
    default public @Nullable T put(@NonNull Map<? super Key<?>, Object> a, @Nullable T value) {
        if (a.containsKey(this)) {
            return this.getRawValueType().cast(a.put(this, value));
        }
        a.put(this, value);
        return this.getDefaultValue();
    }

    @Override
    default public @NonNull ImmutableMap<Key<?>, Object> put(@NonNull ImmutableMap<Key<?>, Object> a, @Nullable T value) {
        return a.put((Object)this, value);
    }

    @Override
    default public @Nullable T remove(@NonNull Map<? super Key<?>, Object> a) {
        if (a.containsKey(this)) {
            return this.getRawValueType().cast(a.remove(this));
        }
        return this.getDefaultValue();
    }

    @Override
    default public @NonNull ImmutableMap<Key<?>, Object> remove(@NonNull ImmutableMap<Key<?>, Object> a) {
        return a.remove((Object)this);
    }

    default public @Nullable T putValue(@NonNull Map<? super Key<?>, ObjectProperty<?>> a, @Nullable T value) {
        if (!this.isAssignable(value)) {
            throw new IllegalArgumentException("Value is not assignable to key. key=" + String.valueOf(this) + ", value=" + String.valueOf(value));
        }
        if (a.containsKey(this)) {
            ObjectProperty<?> p = a.get(this);
            Object oldValue = p.get();
            p.set(value);
            return (T)oldValue;
        }
        a.put(this, (ObjectProperty<?>)new SimpleObjectProperty(value));
        return null;
    }

    public boolean isNullable();

    default public boolean isAssignable(@Nullable Object value) {
        ParameterizedType pt;
        Type type;
        Type type2 = this.getValueType();
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            return value == null && this.isNullable() || clazz.isInstance(value);
        }
        type2 = this.getValueType();
        if (type2 instanceof ParameterizedType && (type = (pt = (ParameterizedType)type2).getRawType()) instanceof Class) {
            Class clazz = (Class)type;
            return value == null && this.isNullable() || clazz.isInstance(value);
        }
        return value == null && this.isNullable();
    }

    default public boolean isDefault(@Nullable Object value) {
        return Objects.equals(this.getDefaultValue(), value);
    }

    default public @NonNull Binding<T> valueAt(@NonNull ObservableMap<Key<?>, Object> map) {
        ObjectBinding value;
        ObjectBinding binding = value = Bindings.valueAt(map, (Object)this);
        return binding;
    }

    default public @NonNull ObjectProperty<T> propertyAt(@NonNull ObservableMap<Key<?>, Object> map) {
        return new KeyMapEntryProperty(map, this);
    }

    default public @NonNull ReadOnlyProperty<T> readOnlyPropertyAt(@NonNull ObservableMap<Key<?>, Object> map) {
        return new KeyMapEntryProperty(map, this);
    }

    default public @NonNull T cast(Object value) {
        return this.getRawValueType().cast(value);
    }
}

