/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;

public abstract class AbstractObservableSet<E>
extends AbstractSet<E>
implements ObservableSet<E>,
ReadOnlySet<E> {
    private final List<SetChangeListener<? super E>> changeListeners = new CopyOnWriteArrayList<SetChangeListener<? super E>>();
    private final List<InvalidationListener> invalidationListeners = new CopyOnWriteArrayList<InvalidationListener>();

    @Override
    public boolean add(E e) {
        boolean modified = this.backingSetAdd(e);
        if (modified) {
            this.fireAdded(e);
            this.fireInvalidated();
        }
        return modified;
    }

    protected abstract boolean backingSetAdd(E var1);

    @Override
    public boolean addAll(@NonNull Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            boolean added = this.backingSetAdd(e);
            if (!added) continue;
            this.fireAdded(e);
            modified = true;
        }
        if (modified) {
            this.fireInvalidated();
        }
        return modified;
    }

    public void addListener(InvalidationListener listener) {
        this.invalidationListeners.add(listener);
    }

    public void addListener(SetChangeListener<? super E> listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void clear() {
        Object[] values = this.backingSetToArray();
        this.backingSetClear();
        for (Object v : values) {
            this.fireRemoved(v);
        }
        if (values.length > 0) {
            this.fireInvalidated();
        }
    }

    @Override
    public Stream<E> stream() {
        return super.stream();
    }

    protected abstract void backingSetClear();

    protected abstract Object[] backingSetToArray();

    @Override
    public boolean contains(@Nullable Object o) {
        return this.backingSetContains(o);
    }

    protected abstract boolean backingSetContains(Object var1);

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.backingSetContainsAll(c);
    }

    protected abstract boolean backingSetContainsAll(Collection<?> var1);

    protected void fireAdded(@Nullable E e) {
        Change<E> change = null;
        for (SetChangeListener<? super E> setChangeListener : this.changeListeners) {
            if (change == null) {
                change = new Change<E>(this, e, true);
            }
            setChangeListener.onChanged(change);
        }
    }

    private void fireInvalidated() {
        this.invalidated();
        for (InvalidationListener l : this.invalidationListeners) {
            l.invalidated((Observable)this);
        }
    }

    protected void fireRemoved(@Nullable E e) {
        Change<E> change = null;
        for (SetChangeListener<? super E> setChangeListener : this.changeListeners) {
            if (change == null) {
                change = new Change<E>(this, e, false);
            }
            setChangeListener.onChanged(change);
        }
    }

    public void fireUpdated(@Nullable E e) {
        this.fireRemoved(e);
        this.fireAdded(e);
        this.fireInvalidated();
    }

    protected void invalidated() {
    }

    @Override
    public boolean isEmpty() {
        return this.backingSetIsEmpty();
    }

    protected abstract boolean backingSetIsEmpty();

    @Override
    public @NonNull Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<? extends E> i;
            private @Nullable E current;
            {
                this.i = AbstractObservableSet.this.backingSetIterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                this.current = this.i.next();
                return this.current;
            }

            @Override
            public void remove() {
                this.i.remove();
                AbstractObservableSet.this.fireRemoved(this.current);
                AbstractObservableSet.this.fireInvalidated();
            }
        };
    }

    protected abstract Iterator<E> backingSetIterator();

    @Override
    public boolean remove(@Nullable Object o) {
        boolean modified = this.backingSetRemove(o);
        if (modified) {
            Object e = o;
            this.fireRemoved(e);
            this.fireInvalidated();
        }
        return modified;
    }

    protected abstract boolean backingSetRemove(Object var1);

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            Object e = o;
            boolean removed = this.backingSetRemove(e);
            if (!removed) continue;
            this.fireRemoved(e);
            modified = true;
        }
        if (modified) {
            this.fireInvalidated();
        }
        return modified;
    }

    public void removeListener(InvalidationListener listener) {
        this.invalidationListeners.remove(listener);
    }

    public void removeListener(SetChangeListener<? super E> listener) {
        this.changeListeners.remove(listener);
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        boolean modified = false;
        Iterator<E> it = this.backingSetIterator();
        while (it.hasNext()) {
            E e = it.next();
            if (c.contains(e)) continue;
            it.remove();
            this.fireRemoved(e);
            modified = true;
        }
        if (modified) {
            this.fireInvalidated();
        }
        return modified;
    }

    @Override
    public int size() {
        return this.backingSetSize();
    }

    protected abstract int backingSetSize();

    private static class Change<EE>
    extends SetChangeListener.Change<EE> {
        private final @Nullable EE value;
        private final boolean wasAdded;

        public Change(ObservableSet<EE> set, @Nullable EE value, boolean wasAdded) {
            super(set);
            this.value = value;
            this.wasAdded = wasAdded;
        }

        public @Nullable EE getElementAdded() {
            return this.wasAdded ? (EE)this.value : null;
        }

        public @Nullable EE getElementRemoved() {
            return !this.wasAdded ? (EE)this.value : null;
        }

        public boolean wasAdded() {
            return this.wasAdded;
        }

        public boolean wasRemoved() {
            return !this.wasAdded;
        }
    }
}

