/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection;

import java.util.Objects;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class StrongMapEntryProperty<K, V, T extends V>
extends ObjectPropertyBase<T>
implements MapChangeListener<K, V> {
    private @Nullable K key;
    private @Nullable ObservableMap<K, V> map;
    private char changing;

    public StrongMapEntryProperty(@NonNull ObservableMap<K, V> map, @NonNull K key, @NonNull Class<T> tClazz) {
        this.map = map;
        this.key = key;
        map.addListener((MapChangeListener)this);
    }

    public @Nullable T get() {
        Object temp = this.map.get(this.key);
        return (T)temp;
    }

    public @Nullable Object getBean() {
        return this.map;
    }

    public String getName() {
        return this.key.toString();
    }

    public void onChanged(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MapChangeListener.Change<? extends K, ? extends V> change) {
        char c = this.changing;
        this.changing = (char)(c + '\u0001');
        if (c == '\u0000' && this.key.equals(change.getKey())) {
            if (change.wasAdded()) {
                Object valueAdded = change.getValueAdded();
                if (!Objects.equals(super.get(), valueAdded)) {
                    this.set(valueAdded);
                }
            } else if (change.wasRemoved() && super.get() != null) {
                this.set(null);
            }
        }
        this.changing = (char)(this.changing - '\u0001');
    }

    public void set(@Nullable T value) {
        if (this.map != null) {
            this.map.put(this.key, value);
            super.set(value);
        }
    }

    public void unbind() {
        super.unbind();
        if (this.map != null) {
            this.map.removeListener((MapChangeListener)this);
            this.map = null;
            this.key = null;
        }
    }
}

