/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection.typesafekey;

import java.lang.reflect.Type;
import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.TypeToken;

public abstract class AbstractKey<T>
implements Key<T> {
    private final @NonNull String name;
    private final @Nullable T initialValue;
    private final @NonNull Type type;
    private final boolean isNullable;
    private final boolean isTransient;

    public AbstractKey(@NonNull String name, @NonNull Type clazz) {
        this(name, clazz, null);
    }

    public AbstractKey(@NonNull String name, @NonNull TypeToken<T> clazz, T initialValue) {
        this(name, clazz.getType(), initialValue);
    }

    public AbstractKey(@NonNull String name, @NonNull Type clazz, @Nullable T initialValue) {
        this(name, clazz, true, initialValue);
    }

    public AbstractKey(@NonNull String name, @NonNull Type clazz, boolean isNullable, @Nullable T initialValue) {
        this(name, clazz, isNullable, false, initialValue);
    }

    public AbstractKey(@NonNull String name, @NonNull Type clazz, @Nullable Class<?>[] typeParameters, boolean isNullable, @Nullable T initialValue) {
        this(name, clazz, isNullable, false, initialValue);
    }

    public AbstractKey(@Nullable String name, @NonNull Type clazz, boolean isNullable, boolean isTransient, @Nullable T initialValue) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(clazz, "clazz");
        if (!isNullable && initialValue == null) {
            throw new IllegalArgumentException("defaultValue may not be null if isNullable==false");
        }
        this.name = name;
        this.type = clazz;
        this.isNullable = isNullable;
        this.isTransient = isTransient;
        this.initialValue = initialValue;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull Type getValueType() {
        return this.type;
    }

    @Override
    public @Nullable T getDefaultValue() {
        return this.initialValue;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    public @NonNull String toString() {
        String keyClass = this.getClass().getName();
        return keyClass.substring(keyClass.lastIndexOf(46) + 1) + "@" + System.identityHashCode(this) + " {\"" + this.name + "\"}";
    }
}

