/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection.typesafekey;

import java.util.Map;
import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxcollection.typesafekey.CompositeMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.ChampVectorSet;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jhotdraw8.icollection.immutable.ImmutableSequencedSet;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;

public class SetValueMapAccessor<E>
implements CompositeMapAccessor<Boolean> {
    private final @NonNull MapAccessor<ImmutableSet<E>> setAccessor;
    private final @Nullable E value;
    private final boolean defaultValue;
    private final @NonNull String name;
    private final boolean isTransient;

    public SetValueMapAccessor(@NonNull String name, boolean isTransient, @NonNull MapAccessor<ImmutableSet<E>> setAccessor, @Nullable E value, boolean defaultValue) {
        Objects.requireNonNull(value, "value");
        this.setAccessor = setAccessor;
        this.value = value;
        this.defaultValue = defaultValue;
        this.name = name;
        this.isTransient = isTransient;
    }

    public SetValueMapAccessor(@NonNull String name, @NonNull MapAccessor<ImmutableSet<E>> setAccessor, E value) {
        this(name, false, setAccessor, value, false);
    }

    @Override
    public Boolean get(@NonNull Map<? super Key<?>, Object> a) {
        ImmutableSet<E> es = this.setAccessor.get(a);
        return es != null && es.contains(this.value);
    }

    @Override
    public Boolean get(@NonNull ReadOnlyMap<? super Key<?>, Object> a) {
        ImmutableSet<E> es = this.setAccessor.get(a);
        return es != null && es.contains(this.value);
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull ImmutableSequencedSet<MapAccessor<?>> getSubAccessors() {
        return ChampVectorSet.of((Object[])new MapAccessor[]{this.setAccessor});
    }

    @Override
    public @NonNull Class<Boolean> getValueType() {
        return Boolean.class;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public Boolean put(@NonNull Map<? super Key<?>, Object> a, @Nullable Boolean value) {
        ImmutableSet set = this.setAccessor.get(a);
        assert (set != null);
        boolean oldValue = set.contains(this.value);
        set = value != null && value != false ? set.add(this.value) : set.remove(this.value);
        this.setAccessor.put(a, set);
        return oldValue;
    }

    @Override
    public @NonNull ImmutableMap<Key<?>, Object> put(@NonNull ImmutableMap<Key<?>, Object> a, @Nullable Boolean value) {
        ImmutableSet set = this.setAccessor.get((ReadOnlyMap<Key<?>, Object>)a);
        assert (set != null);
        set = value != null && value != false ? set.add(this.value) : set.remove(this.value);
        return this.setAccessor.put(a, set);
    }

    @Override
    public Boolean remove(@NonNull Map<? super Key<?>, Object> a) {
        return this.put(a, (Boolean)false);
    }

    @Override
    public @NonNull ImmutableMap<Key<?>, Object> remove(@NonNull ImmutableMap<Key<?>, Object> a) {
        return this.setAccessor.remove(a);
    }
}

