/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection.typesafekey;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public record SimpleParameterizedType(@NonNull Type rawType, @NonNull Type[] actualTypeArguments) implements ParameterizedType
{
    public @NonNull Type getTypeArgument(int i) {
        return this.actualTypeArguments[i];
    }

    public int getTypeArgumentCount() {
        return this.actualTypeArguments.length;
    }

    @Override
    public @NonNull String getTypeName() {
        StringBuilder b = new StringBuilder();
        b.append(this.rawType.getTypeName());
        b.append('<');
        int first = b.length();
        for (Type t : this.actualTypeArguments) {
            if (b.length() != first) {
                b.append(',');
            }
            b.append(t.getTypeName());
        }
        b.append('>');
        return b.toString();
    }

    @Override
    public Type @NonNull [] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    @Override
    public @NonNull Type getRawType() {
        return this.rawType;
    }

    @Override
    public @Nullable Type getOwnerType() {
        return null;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleParameterizedType that = (SimpleParameterizedType)o;
        return Objects.equals(this.rawType, that.rawType) && Arrays.equals(this.actualTypeArguments, that.actualTypeArguments);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.rawType);
        result = 31 * result + Arrays.hashCode(this.actualTypeArguments);
        return result;
    }

    @Override
    public String toString() {
        return "SimpleParameterizedType{" + String.valueOf(this.rawType) + "<" + Arrays.stream(this.actualTypeArguments).map(Type::getTypeName).collect(Collectors.joining(", ")) + ">}";
    }
}

