/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection;

import java.lang.reflect.Type;
import java.util.Objects;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.WeakMapChangeListener;
import org.jspecify.annotations.Nullable;

public class MapEntryProperty<K, V, T extends V>
extends ObjectPropertyBase<T>
implements MapChangeListener<K, V> {
    protected K key;
    protected ObservableMap<K, V> map;
    private @Nullable WeakMapChangeListener<K, V> weakListener;
    private char changing;

    public MapEntryProperty(ObservableMap<K, V> map, K key, Type tClazz) {
        this.map = map;
        this.key = key;
        this.weakListener = new WeakMapChangeListener((MapChangeListener)this);
        map.addListener((MapChangeListener)this.weakListener);
    }

    public @Nullable T get() {
        Object temp = this.map.get(this.key);
        return (T)temp;
    }

    public @Nullable Object getBean() {
        return this.map;
    }

    public String getName() {
        return this.key.toString();
    }

    public void onChanged(MapChangeListener.Change<? extends K, ? extends V> change) {
        char c = this.changing;
        this.changing = (char)(c + '\u0001');
        if (c == '\u0000' && this.key.equals(change.getKey())) {
            if (change.wasAdded()) {
                Object valueAdded = change.getValueAdded();
                if (!Objects.equals(super.get(), valueAdded)) {
                    this.set(valueAdded);
                }
            } else if (change.wasRemoved() && super.get() != null) {
                this.set(null);
            }
        }
        this.changing = (char)(this.changing - '\u0001');
    }

    public void set(@Nullable T value) {
        T temp = value;
        this.map.put(this.key, temp);
        super.set(value);
    }

    public void unbind() {
        super.unbind();
        this.map.removeListener(this.weakListener);
        this.weakListener = null;
        this.map = null;
        this.key = null;
    }
}

