/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jhotdraw8.fxcollection.AbstractObservableSet;

public class ModifiableObservableSet<E>
extends AbstractObservableSet<E> {
    private Set<E> backingSet;

    public ModifiableObservableSet(Collection<E> copyMe) {
        this.backingSet = new LinkedHashSet<E>(copyMe);
    }

    public void setBackingSet(Set<E> backingSet) {
        this.backingSet = backingSet;
    }

    public ModifiableObservableSet() {
    }

    @Override
    protected boolean backingSetAdd(E e) {
        this.makeBackingSet();
        return this.backingSet.add(e);
    }

    private void makeBackingSet() {
        if (this.backingSet == null) {
            this.backingSet = new LinkedHashSet();
        }
    }

    @Override
    protected void backingSetClear() {
        if (this.backingSet != null) {
            this.backingSet.clear();
        }
    }

    @Override
    protected Object[] backingSetToArray() {
        return this.backingSet == null ? new Object[]{} : this.backingSet.toArray();
    }

    @Override
    protected boolean backingSetContains(Object o) {
        return this.backingSet != null && this.backingSet.contains(o);
    }

    @Override
    protected boolean backingSetContainsAll(Collection<?> c) {
        return this.backingSet != null && this.backingSet.containsAll(c);
    }

    @Override
    protected boolean backingSetIsEmpty() {
        return this.backingSet == null || this.backingSet.isEmpty();
    }

    @Override
    protected Iterator<E> backingSetIterator() {
        return this.backingSet == null ? Collections.emptyIterator() : this.backingSet.iterator();
    }

    @Override
    protected boolean backingSetRemove(Object o) {
        return this.backingSet != null && this.backingSet.remove(o);
    }

    @Override
    protected int backingSetSize() {
        return this.backingSet == null ? 0 : this.backingSet.size();
    }
}

