/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection;

import java.util.ArrayList;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;

public class ReversedObservableList<E>
extends TransformationList<E, E> {
    private int size;

    public ReversedObservableList(ObservableList<E> source) {
        super(source);
        this.size = source.size();
    }

    protected void sourceChanged(ListChangeListener.Change<? extends E> c) {
        this.beginChange();
        while (c.next()) {
            if (c.wasPermutated()) {
                int from = c.getFrom();
                int[] perm = new int[c.getTo() - from];
                for (int i = from; i < c.getTo(); ++i) {
                    perm[i - from] = this.size - c.getPermutation(i);
                }
                this.nextPermutation(this.size - 1 - c.getTo(), this.size - 1 - c.getFrom(), perm);
                continue;
            }
            if (c.wasUpdated()) {
                for (int i = c.getFrom(); i < c.getTo(); ++i) {
                    this.nextUpdate(this.size - 1 - i);
                }
                continue;
            }
            if (c.wasRemoved()) {
                ArrayList reversed = new ArrayList(c.getRemoved());
                int n = c.getRemovedSize();
                for (int i = 0; i < n; ++i) {
                    reversed.set(n - i - 1, c.getRemoved().get(i));
                }
                this.size -= c.getRemovedSize();
                this.nextRemove(this.size - c.getFrom() - c.getRemovedSize() + 1, reversed);
            }
            if (!c.wasAdded()) continue;
            this.size += c.getAddedSize();
            this.nextAdd(this.size - c.getTo(), this.size - c.getFrom());
        }
        assert (this.size == this.getSource().size()) : "ReversedObservableList this.size=" + this.size + " sourceSize:" + this.getSource().size();
        this.endChange();
    }

    public int getSourceIndex(int index) {
        return this.size - 1 - index;
    }

    public int getViewIndex(int index) {
        return this.size - 1 - index;
    }

    public E get(int index) {
        return (E)this.getSource().get(this.getSourceIndex(index));
    }

    public E set(int index, E e) {
        ObservableList tmp = this.getSource();
        return tmp.set(this.getSourceIndex(index), e);
    }

    public E remove(int index) {
        return (E)this.getSource().remove(this.getSourceIndex(index));
    }

    public boolean remove(Object o) {
        return this.getSource().remove(o);
    }

    public int size() {
        return this.size;
    }

    public void add(int index, E element) {
        ObservableList src = this.getSource();
        src.add(this.size - Math.min(this.size, index), element);
    }

    public void fireUpdated(int from, int to) {
        this.beginChange();
        for (int i = from; i < to; ++i) {
            this.nextUpdate(i);
        }
        this.endChange();
    }
}

