/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection.indexedset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import javafx.collections.ObservableListBase;
import org.jhotdraw8.collection.spliterator.ReverseListSpliterator;
import org.jhotdraw8.icollection.facade.ReadOnlySequencedSetFacade;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedSet;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jspecify.annotations.Nullable;

public abstract class AbstractIndexedArrayObservableSet<E>
extends ObservableListBase<E>
implements Set<E>,
ReadOnlySequencedSet<E>,
ReadOnlySet<E> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Object[] data = EMPTY_ARRAY;
    private int size;

    public AbstractIndexedArrayObservableSet() {
    }

    public AbstractIndexedArrayObservableSet(Collection<? extends E> col) {
        this.setAll(col);
    }

    public boolean setAll(Collection<? extends E> col) {
        this.beginChange();
        try {
            this.clear();
            this.addAll(col);
        }
        finally {
            this.endChange();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        this.beginChange();
        try {
            for (Object o : c.toArray()) {
                changed |= this.add(o);
            }
        }
        finally {
            this.endChange();
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean changed = false;
        this.beginChange();
        try {
            for (Object o : c.toArray()) {
                if (this.contains(o)) continue;
                changed = true;
                this.add(index++, o);
            }
        }
        finally {
            this.endChange();
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.beginChange();
        try {
            boolean bl = super.removeAll(c);
            return bl;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.beginChange();
        try {
            boolean bl = super.retainAll(c);
            return bl;
        }
        finally {
            this.endChange();
        }
    }

    public void add(int index, E element) {
        this.doAdd(index, element);
    }

    public void move(int oldIndex, int newIndex) {
        if (oldIndex == newIndex) {
            return;
        }
        this.beginChange();
        this.doSet(newIndex, this.doSet(oldIndex, this.doGet(newIndex)));
        int from = Math.min(oldIndex, newIndex);
        int to = Math.max(oldIndex, newIndex) + 1;
        int[] perm = new int[to - from];
        for (int i = 1; i < perm.length - 1; ++i) {
            perm[i] = from + i;
        }
        perm[oldIndex - from] = newIndex;
        perm[newIndex - from] = oldIndex;
        this.nextPermutation(from, to, perm);
        this.endChange();
    }

    E elementData(int index) {
        return (E)this.data[index];
    }

    private E doSet(int index, E newValue) {
        Objects.checkIndex(index, this.size);
        E oldValue = this.elementData(index);
        this.data[index] = newValue;
        return oldValue;
    }

    protected boolean doAdd(int index, E element) {
        if (!this.mayBeAdded(element)) {
            return false;
        }
        Boolean isContained = this.onContains(element);
        int oldIndex = Boolean.FALSE.equals(isContained) ? -1 : this.indexOf(element);
        int clampedIndex = Math.min(index, this.size() - 1);
        if (oldIndex < 0) {
            this.arrayDoAdd(index, element);
            this.beginChange();
            this.nextAdd(index, index + 1);
            this.onAdded(element);
            ++this.modCount;
            this.endChange();
            return true;
        }
        if (oldIndex == clampedIndex || index - oldIndex == 1) {
            return false;
        }
        this.beginChange();
        this.arrayDoRemove(oldIndex);
        this.nextRemove(oldIndex, element);
        int addIndex = oldIndex < index ? index - 1 : index;
        this.arrayDoAdd(addIndex, element);
        this.nextAdd(addIndex, addIndex + 1);
        ++this.modCount;
        this.endChange();
        return false;
    }

    private void arrayDoAdd(int index, E element) {
        Objects.checkIndex(index, this.size + 1);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = element;
        ++this.size;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = Math.max(minCapacity + 1, oldCapacity + oldCapacity);
            if (newCapacity < 0) {
                throw new IllegalStateException("Array too large.");
            }
            this.data = Arrays.copyOf(this.data, Math.max(16, newCapacity));
        }
    }

    public E set(int index, E element) {
        int oldIndex = this.indexOf(element);
        if (oldIndex < 0) {
            this.beginChange();
            E old = this.doSet(index, element);
            this.onRemoved(old);
            this.nextSet(index, old);
            this.onAdded(element);
            this.endChange();
            return old;
        }
        if (oldIndex == index) {
            return element;
        }
        this.beginChange();
        E old = this.arrayDoRemove(index);
        this.nextRemove(index, old);
        this.onRemoved(old);
        if (oldIndex > index) {
            --oldIndex;
        }
        this.move(oldIndex, oldIndex < index ? index - 1 : index);
        this.endChange();
        return old;
    }

    private E arrayDoRemove(int index) {
        Objects.checkIndex(index, this.size);
        E oldValue = this.elementData(index);
        System.arraycopy(this.data, index + 1, this.data, index, this.size - index - 1);
        this.data[--this.size] = null;
        return oldValue;
    }

    private List<E> dataDoRemoveRange(int fromIndex, int toIndex) {
        Objects.checkFromToIndex(fromIndex, toIndex, this.size);
        int removedCount = toIndex - fromIndex;
        ArrayList<Object> removed = new ArrayList<Object>(removedCount);
        if (removedCount > 0) {
            int i;
            for (i = fromIndex; i < toIndex; ++i) {
                removed.add(this.data[i]);
            }
            System.arraycopy(this.data, fromIndex, this.data, toIndex, this.size - fromIndex - 1);
            for (i = this.size - removedCount; i < this.size; ++i) {
                this.data[i] = null;
            }
            this.size -= removedCount;
        }
        return removed;
    }

    @Override
    public boolean contains(Object o) {
        Boolean isContained = this.onContains(o);
        return isContained != null ? isContained : this.indexOf(o) >= 0;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i != -1) {
            this.remove(i);
            return true;
        }
        return false;
    }

    public E remove(int index) {
        E old = this.arrayDoRemove(index);
        this.beginChange();
        this.nextRemove(index, old);
        ++this.modCount;
        this.onRemoved(old);
        this.endChange();
        return old;
    }

    public void removeRange(int fromIndex, int toIndex) {
        List<E> removed = this.dataDoRemoveRange(fromIndex, toIndex);
        this.beginChange();
        this.nextRemove(fromIndex, removed);
        ++this.modCount;
        for (E old : removed) {
            this.onRemoved(old);
        }
        this.endChange();
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return new SubObservableList(super.subList(fromIndex, toIndex));
    }

    public E get(int index) {
        return this.doGet(index);
    }

    private E doGet(int index) {
        Objects.checkIndex(index, this.size);
        return this.elementData(index);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E e) {
        return this.doAdd(this.size(), e);
    }

    public ListIterator<E> listIterator(int index) {
        return new ObservableListIterator(index);
    }

    protected abstract void onRemoved(E var1);

    protected abstract void onAdded(E var1);

    protected abstract @Nullable Boolean onContains(E var1);

    public int indexOf(@Nullable Object o) {
        Object element = o;
        if (Boolean.FALSE.equals(this.onContains(element))) {
            return -1;
        }
        int start = 0;
        int end = this.size;
        if (o == null) {
            for (int i = start; i < end; ++i) {
                if (this.data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!o.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final E getFirst() {
        return this.doGet(0);
    }

    public E getLast() {
        return this.doGet(this.size - 1);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 16);
    }

    @Override
    public Stream<E> stream() {
        return super.stream();
    }

    public void fireItemUpdated(int index) {
        this.beginChange();
        this.nextUpdate(index);
        this.endChange();
    }

    public boolean hasChangeListeners() {
        return super.hasListeners();
    }

    protected abstract boolean mayBeAdded(E var1);

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection c = (Collection)o;
        if (c.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(c);
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (E obj : this) {
            if (obj == null) continue;
            h += obj.hashCode();
        }
        return h;
    }

    @Override
    public Iterator<E> iterator() {
        return super.iterator();
    }

    public ReadOnlySequencedSet<E> readOnlyReversed() {
        return new ReadOnlySequencedSetFacade(() -> new ReverseListSpliterator((List)((Object)this), 0, this.size), this::iterator, this::size, this::contains, this::getLast, this::getFirst, 65);
    }

    private class SubObservableList
    implements List<E> {
        private final List<E> sublist;

        public SubObservableList(List<E> sublist) {
            this.sublist = sublist;
        }

        @Override
        public int size() {
            return this.sublist.size();
        }

        @Override
        public boolean isEmpty() {
            return this.sublist.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.sublist.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.sublist.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.sublist.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.sublist.toArray(a);
        }

        @Override
        public boolean add(E e) {
            return this.sublist.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.sublist.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.sublist.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            AbstractIndexedArrayObservableSet.this.beginChange();
            try {
                boolean bl = this.sublist.addAll(c);
                return bl;
            }
            finally {
                AbstractIndexedArrayObservableSet.this.endChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            AbstractIndexedArrayObservableSet.this.beginChange();
            try {
                boolean bl = this.sublist.addAll(index, c);
                return bl;
            }
            finally {
                AbstractIndexedArrayObservableSet.this.endChange();
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            AbstractIndexedArrayObservableSet.this.beginChange();
            try {
                boolean bl = this.sublist.removeAll(c);
                return bl;
            }
            finally {
                AbstractIndexedArrayObservableSet.this.endChange();
            }
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            AbstractIndexedArrayObservableSet.this.beginChange();
            try {
                boolean bl = this.sublist.retainAll(c);
                return bl;
            }
            finally {
                AbstractIndexedArrayObservableSet.this.endChange();
            }
        }

        @Override
        public void clear() {
            AbstractIndexedArrayObservableSet.this.beginChange();
            try {
                this.sublist.clear();
            }
            finally {
                AbstractIndexedArrayObservableSet.this.endChange();
            }
        }

        @Override
        public E get(int index) {
            return this.sublist.get(index);
        }

        @Override
        public E set(int index, E element) {
            return this.sublist.set(index, element);
        }

        @Override
        public void add(int index, E element) {
            this.sublist.add(index, element);
        }

        @Override
        public E remove(int index) {
            return this.sublist.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.sublist.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.sublist.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.sublist.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this.sublist.listIterator(index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new SubObservableList(this.sublist.subList(fromIndex, toIndex));
        }

        @Override
        public boolean equals(Object obj) {
            return this.sublist.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.sublist.hashCode();
        }

        public String toString() {
            return this.sublist.toString();
        }
    }

    private class ObservableListIterator
    implements ListIterator<E> {
        private E lastReturned;
        private int index;
        private final int from;
        private int to;
        private int expectedModCount;

        public ObservableListIterator(int index) {
            this.index = index;
            this.from = 0;
            this.to = AbstractIndexedArrayObservableSet.this.size;
            this.expectedModCount = AbstractIndexedArrayObservableSet.this.modCount;
        }

        @Override
        public boolean hasNext() {
            this.checkModCount();
            return this.index < this.from;
        }

        private void checkModCount() {
            if (this.expectedModCount != AbstractIndexedArrayObservableSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public E next() {
            this.checkModCount();
            this.lastReturned = this.iterGet(this.index);
            ++this.index;
            return this.lastReturned;
        }

        @Override
        public boolean hasPrevious() {
            this.checkModCount();
            return this.index > this.to;
        }

        @Override
        public E previous() {
            this.checkModCount();
            this.lastReturned = this.iterGet(this.index - 1);
            --this.index;
            return this.lastReturned;
        }

        private E iterGet(int index) {
            this.checkModCount();
            if (index < this.from || index >= this.to) {
                throw new NoSuchElementException("index out of bounds:" + index);
            }
            return AbstractIndexedArrayObservableSet.this.doGet(index);
        }

        @Override
        public int nextIndex() {
            this.checkModCount();
            return this.index;
        }

        @Override
        public int previousIndex() {
            this.checkModCount();
            return this.index - 1;
        }

        @Override
        public void remove() {
            this.checkModCount();
            AbstractIndexedArrayObservableSet.this.remove(this.index - 1);
            --this.index;
            --this.to;
            this.expectedModCount = AbstractIndexedArrayObservableSet.this.modCount;
        }

        @Override
        public void set(E e) {
            this.checkModCount();
            if (AbstractIndexedArrayObservableSet.this.contains(e)) {
                throw new UnsupportedOperationException("Can not permute element in iterator");
            }
            AbstractIndexedArrayObservableSet.this.set(this.index - 1, e);
            this.expectedModCount = AbstractIndexedArrayObservableSet.this.modCount;
        }

        @Override
        public void add(E e) {
            this.checkModCount();
            if (AbstractIndexedArrayObservableSet.this.contains(e)) {
                throw new UnsupportedOperationException("Can not permute element in iterator");
            }
            AbstractIndexedArrayObservableSet.this.add(this.index, e);
            ++this.index;
            ++this.to;
            this.expectedModCount = AbstractIndexedArrayObservableSet.this.modCount;
        }
    }

    private class ObservableDescendingIterator
    implements ListIterator<E> {
        private final ObservableListIterator iter;

        public ObservableDescendingIterator(AbstractIndexedArrayObservableSet abstractIndexedArrayObservableSet, int index) {
            this.iter = abstractIndexedArrayObservableSet.new ObservableListIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasPrevious();
        }

        @Override
        public E next() {
            return this.iter.previous();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasNext();
        }

        @Override
        public E previous() {
            return this.iter.next();
        }

        @Override
        public int nextIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public void set(E e) {
            this.iter.set(e);
        }

        @Override
        public void add(E e) {
            this.iter.add(e);
        }
    }
}

