/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection.mapped;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import org.jspecify.annotations.Nullable;

public class MappedObservableList<A, B>
extends TransformationList<A, B> {
    private final Function<A, B> toB;
    private final Function<B, A> toA;

    public MappedObservableList(ObservableList<B> source, Function<A, B> toB, Function<B, A> toA) {
        super(source);
        this.toB = toB;
        this.toA = toA;
    }

    protected void sourceChanged(ListChangeListener.Change<? extends B> c) {
        this.fireChange(new ChangeProxy<B, A>(this, c, this.toA));
    }

    public int getSourceIndex(int index) {
        return index;
    }

    public int getViewIndex(int index) {
        return index;
    }

    public A get(int index) {
        return this.toA.apply(this.getSource().get(index));
    }

    public int size() {
        return this.getSource().size();
    }

    public A remove(int index) {
        return this.toA.apply(this.getSource().remove(index));
    }

    public boolean remove(Object o) {
        Object a = o;
        return this.getSource().remove(this.toB.apply(a));
    }

    public void add(int index, A e) {
        ObservableList source = this.getSource();
        source.add(index, this.toB.apply(e));
    }

    public boolean add(A e) {
        ObservableList src = this.getSource();
        return src.add(this.toB.apply(e));
    }

    public A set(int index, A e) {
        ObservableList src = this.getSource();
        return this.toA.apply(src.set(index, this.toB.apply(e)));
    }

    public void remove(int from, int to) {
        ObservableList src = this.getSource();
        src.remove(from, to);
    }

    public static class ChangeProxy<B, A>
    extends ListChangeListener.Change<A> {
        private final ListChangeListener.Change<? extends B> change;
        private final Function<B, A> toA;
        private int @Nullable [] perm;

        public ChangeProxy(ObservableList<A> list, ListChangeListener.Change<? extends B> change, Function<B, A> toA) {
            super(list);
            this.change = change;
            this.toA = toA;
        }

        public boolean next() {
            this.perm = null;
            return this.change.next();
        }

        public void reset() {
            this.change.reset();
        }

        public int getTo() {
            return this.change.getTo();
        }

        public List<A> getRemoved() {
            List temp = this.change.getRemoved();
            ArrayList<A> list = new ArrayList<A>(temp.size());
            for (Object b : temp) {
                list.add(this.toA.apply(b));
            }
            return list;
        }

        public int getFrom() {
            return this.change.getFrom();
        }

        public boolean wasUpdated() {
            return this.change.wasUpdated();
        }

        protected int @Nullable [] getPermutation() {
            if (this.perm == null) {
                if (this.change.wasPermutated()) {
                    int from = this.change.getFrom();
                    int n = this.change.getTo() - from;
                    this.perm = new int[n];
                    for (int i = 0; i < n; ++i) {
                        this.perm[i] = this.change.getPermutation(from + i);
                    }
                } else {
                    this.perm = new int[0];
                }
            }
            return this.perm;
        }
    }
}

