/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection.sharedkeys;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import org.jspecify.annotations.Nullable;

public class SharedKeysMap<K, V>
extends AbstractMap<K, V>
implements ObservableMap<K, V> {
    private static final Object NULL_VALUE = new Object();
    private CopyOnWriteArrayList<MapChangeListener<? super K, ? super V>> changeListenerList;
    private CopyOnWriteArrayList<InvalidationListener> invalidationListenerList;
    private final Map<K, Integer> keyMap;
    private int size;
    private final Object[] values;

    public SharedKeysMap(Map<K, Integer> keyMap) {
        this.keyMap = keyMap;
        this.values = new Object[keyMap.size()];
    }

    public void addListener(InvalidationListener listener) {
        if (this.invalidationListenerList == null) {
            this.invalidationListenerList = new CopyOnWriteArrayList();
        }
        this.invalidationListenerList.add(listener);
    }

    public void addListener(MapChangeListener<? super K, ? super V> observer) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new CopyOnWriteArrayList();
        }
        this.changeListenerList.add(observer);
    }

    private boolean hasObservers() {
        return this.changeListenerList != null || this.invalidationListenerList != null;
    }

    protected void callObservers(MapChangeListener.Change<K, V> change) {
        if (this.changeListenerList != null) {
            for (MapChangeListener<? super K, ? super V> mapChangeListener : this.changeListenerList) {
                mapChangeListener.onChanged(change);
            }
        }
        if (this.invalidationListenerList != null) {
            for (InvalidationListener invalidationListener : this.invalidationListenerList) {
                invalidationListener.invalidated((Observable)this);
            }
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object key) {
        Integer index = this.keyMap.get(key);
        boolean result = index != null && index < this.values.length && this.values[index] != null;
        return result;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            for (Object o : this.values) {
                if (o != NULL_VALUE) continue;
                return true;
            }
        } else {
            for (Object o : this.values) {
                if (!Objects.equals(o, value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public @Nullable V get(Object key) {
        Integer index = this.keyMap.get(key);
        return index == null ? null : (V)this.getValue(index, key);
    }

    private @Nullable V getValue(int index, K key) {
        Object value = index < this.values.length ? this.values[index] : null;
        return (V)(value == NULL_VALUE ? null : value);
    }

    private boolean hasValue(int index) {
        return index < this.values.length && this.values[index] != null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public @Nullable V put(K key, V value) {
        Integer index = this.keyMap.get(key);
        if (index == null) {
            throw new UnsupportedOperationException("Cannot put key=" + String.valueOf(key) + " value=" + String.valueOf(value));
        }
        return this.setValue(index, key, value);
    }

    @Override
    public @Nullable V remove(Object key) {
        Integer index = this.keyMap.get(key);
        if (index == null) {
            throw new UnsupportedOperationException("cannot remove key=" + String.valueOf(key));
        }
        return this.removeValue(index, key);
    }

    public void removeListener(InvalidationListener listener) {
        if (this.invalidationListenerList != null) {
            this.invalidationListenerList.remove(listener);
        }
    }

    public void removeListener(MapChangeListener<? super K, ? super V> observer) {
        if (this.changeListenerList != null) {
            this.changeListenerList.remove(observer);
        }
    }

    private @Nullable V removeValue(int index, K key) {
        Object returnValue;
        Object oldValue;
        Object object = oldValue = index < this.values.length ? this.values[index] : null;
        if (oldValue == null) {
            return null;
        }
        this.values[index] = null;
        --this.size;
        Object object2 = returnValue = oldValue == NULL_VALUE ? null : oldValue;
        if (this.hasObservers()) {
            ChangeEvent change = new ChangeEvent(this, key, returnValue, null, false, true);
            this.callObservers(change);
        }
        return (V)returnValue;
    }

    private @Nullable V setValue(int index, K key, V newValue) {
        Object returnValue;
        Object oldValue = this.values[index];
        if (oldValue == null) {
            ++this.size;
        }
        this.values[index] = newValue;
        Object object = returnValue = oldValue == NULL_VALUE ? null : oldValue;
        if (this.hasObservers() && (oldValue == null || !Objects.equals(oldValue, newValue))) {
            ChangeEvent change = new ChangeEvent(this, key, returnValue, newValue, true, oldValue != null);
            this.callObservers(change);
        }
        return (V)returnValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            SharedKeysMap.this.clear();
        }

        @Override
        public int size() {
            return SharedKeysMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SharedKeysMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SharedKeysMap.this.containsKey(e.getKey()) && Objects.equals(SharedKeysMap.this.get(e.getKey()), e.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<K, Integer>> entryIt;
                private boolean hasNext;
                private K nextKey;
                private K lastKey;
                private int nextValue;
                private int lastValue;
                {
                    this.entryIt = SharedKeysMap.this.keyMap.entrySet().iterator();
                    this.advance();
                }

                private void advance() {
                    while (this.entryIt.hasNext()) {
                        Map.Entry entry = this.entryIt.next();
                        if (!SharedKeysMap.this.hasValue(entry.getValue())) continue;
                        this.nextKey = entry.getKey();
                        this.nextValue = entry.getValue();
                        this.hasNext = true;
                        return;
                    }
                    this.hasNext = false;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public Map.Entry<K, V> next() {
                    this.lastKey = this.nextKey;
                    this.lastValue = this.nextValue;
                    this.advance();
                    return new MapEntry(this.lastKey, this.lastValue);
                }

                @Override
                public void remove() {
                    SharedKeysMap.this.removeValue(this.lastValue, this.lastKey);
                }
            };
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            boolean added;
            boolean bl = added = !SharedKeysMap.this.containsKey(e.getKey()) || Objects.equals(SharedKeysMap.this.get(e.getKey()), e.getValue());
            if (added) {
                SharedKeysMap.this.put(e.getKey(), e.getValue());
            }
            return added;
        }

        @Override
        public boolean remove(Object o) {
            boolean removed;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            boolean bl = removed = SharedKeysMap.this.containsKey(e.getKey()) && Objects.equals(SharedKeysMap.this.get(e.getKey()), e.getValue());
            if (removed) {
                SharedKeysMap.this.remove(e.getKey());
            }
            return removed;
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return SharedKeysMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SharedKeysMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return SharedKeysMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                private final Iterator<Map.Entry<K, Integer>> entryIt;
                private boolean hasNext;
                private K nextKey;
                private K currentKey;
                {
                    this.entryIt = SharedKeysMap.this.keyMap.entrySet().iterator();
                    this.advance();
                }

                private void advance() {
                    while (this.entryIt.hasNext()) {
                        Map.Entry entry = this.entryIt.next();
                        if (!SharedKeysMap.this.hasValue(entry.getValue())) continue;
                        this.nextKey = entry.getKey();
                        this.hasNext = true;
                        return;
                    }
                    this.hasNext = false;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public K next() {
                    this.currentKey = this.nextKey;
                    this.advance();
                    return this.currentKey;
                }

                @Override
                public void remove() {
                    SharedKeysMap.this.remove(this.currentKey);
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            boolean removed = SharedKeysMap.this.containsKey(o);
            if (removed) {
                SharedKeysMap.this.remove(o);
            }
            return removed;
        }

        @Override
        public void clear() {
            SharedKeysMap.this.clear();
        }
    }

    private class ChangeEvent
    extends MapChangeListener.Change<K, V> {
        private final K key;
        private final V old;
        private final V added;
        private final boolean wasAdded;
        private final boolean wasRemoved;

        public ChangeEvent(SharedKeysMap sharedKeysMap, K key, V old, V added, boolean wasAdded, boolean wasRemoved) {
            super((ObservableMap)sharedKeysMap);
            assert (wasAdded || wasRemoved);
            this.key = key;
            this.old = old;
            this.added = added;
            this.wasAdded = wasAdded;
            this.wasRemoved = wasRemoved;
        }

        public String toString() {
            return "ChangeEvent{key=" + String.valueOf(this.key) + ", old=" + String.valueOf(this.old) + ", added=" + String.valueOf(this.added) + ", wasAdded=" + this.wasAdded + ", wasRemoved=" + this.wasRemoved + "}";
        }

        public boolean wasAdded() {
            return this.wasAdded;
        }

        public boolean wasRemoved() {
            return this.wasRemoved;
        }

        public K getKey() {
            return this.key;
        }

        public V getValueAdded() {
            return this.added;
        }

        public V getValueRemoved() {
            return this.old;
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        @Override
        public int size() {
            return SharedKeysMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SharedKeysMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return SharedKeysMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private final Iterator<Map.Entry<K, Integer>> entryIt;
                private boolean hasNext;
                private K nextKey;
                private K currentKey;
                private @Nullable V nextValue;
                private @Nullable V currentValue;
                {
                    this.entryIt = SharedKeysMap.this.keyMap.entrySet().iterator();
                    this.advance();
                }

                private void advance() {
                    while (this.entryIt.hasNext()) {
                        Map.Entry entry = this.entryIt.next();
                        if (!SharedKeysMap.this.hasValue(entry.getValue())) continue;
                        this.nextKey = entry.getKey();
                        this.nextValue = SharedKeysMap.this.getValue(entry.getValue(), this.nextKey);
                        this.hasNext = true;
                        return;
                    }
                    this.hasNext = false;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public @Nullable V next() {
                    this.currentKey = this.nextKey;
                    this.currentValue = this.nextValue;
                    this.advance();
                    return this.currentValue;
                }

                @Override
                public void remove() {
                    SharedKeysMap.this.remove(this.currentKey);
                }
            };
        }

        @Override
        public void clear() {
            SharedKeysMap.this.clear();
        }
    }

    private class MapEntry
    implements Map.Entry<K, V> {
        private final K key;
        private final int index;

        public MapEntry(K key, int index) {
            this.key = key;
            this.index = index;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public @Nullable V getValue() {
            return SharedKeysMap.this.getValue(this.index, this.key);
        }

        @Override
        public @Nullable V setValue(V value) {
            Object oldValue = SharedKeysMap.this.getValue(this.index, this.key);
            SharedKeysMap.this.setValue(this.index, this.key, value);
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            if (Objects.equals(k1, k2 = e.getKey())) {
                Object v1 = this.getValue();
                Object v2 = e.getValue();
                return Objects.equals(v1, v2);
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public final @Nullable String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }
}

