/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcollection.typesafekey;

import java.util.Map;
import java.util.Objects;
import org.jhotdraw8.fxcollection.typesafekey.CompositeMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.ChampVectorSet;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jhotdraw8.icollection.immutable.ImmutableSequencedSet;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;
import org.jspecify.annotations.Nullable;

public class SetValueMapAccessor<E>
implements CompositeMapAccessor<Boolean> {
    private final MapAccessor<ImmutableSet<E>> setAccessor;
    private final @Nullable E value;
    private final boolean defaultValue;
    private final String name;
    private final boolean isTransient;

    public SetValueMapAccessor(String name, boolean isTransient, MapAccessor<ImmutableSet<E>> setAccessor, @Nullable E value, boolean defaultValue) {
        Objects.requireNonNull(value, "value");
        this.setAccessor = setAccessor;
        this.value = value;
        this.defaultValue = defaultValue;
        this.name = name;
        this.isTransient = isTransient;
    }

    public SetValueMapAccessor(String name, MapAccessor<ImmutableSet<E>> setAccessor, E value) {
        this(name, false, setAccessor, value, false);
    }

    @Override
    public Boolean get(Map<? super Key<?>, Object> a) {
        ImmutableSet<E> es = this.setAccessor.get(a);
        return es != null && es.contains(this.value);
    }

    @Override
    public Boolean get(ReadOnlyMap<? super Key<?>, Object> a) {
        ImmutableSet<E> es = this.setAccessor.get(a);
        return es != null && es.contains(this.value);
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutableSequencedSet<MapAccessor<?>> getSubAccessors() {
        return ChampVectorSet.of((Object[])new MapAccessor[]{this.setAccessor});
    }

    @Override
    public Class<Boolean> getValueType() {
        return Boolean.class;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public Boolean put(Map<? super Key<?>, Object> a, @Nullable Boolean value) {
        ImmutableSet set = this.setAccessor.get(a);
        assert (set != null);
        boolean oldValue = set.contains(this.value);
        set = value != null && value != false ? set.add(this.value) : set.remove(this.value);
        this.setAccessor.put(a, set);
        return oldValue;
    }

    @Override
    public ImmutableMap<Key<?>, Object> put(ImmutableMap<Key<?>, Object> a, @Nullable Boolean value) {
        ImmutableSet set = this.setAccessor.get((ReadOnlyMap<Key<?>, Object>)a);
        assert (set != null);
        set = value != null && value != false ? set.add(this.value) : set.remove(this.value);
        return this.setAccessor.put(a, set);
    }

    @Override
    public Boolean remove(Map<? super Key<?>, Object> a) {
        return this.put(a, (Boolean)false);
    }

    @Override
    public ImmutableMap<Key<?>, Object> remove(ImmutableMap<Key<?>, Object> a) {
        return this.setAccessor.remove(a);
    }
}

