/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import java.io.IOException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.concurrent.TileTask;
import org.jhotdraw8.color.NamedColorSpace;
import org.jhotdraw8.color.RgbBitConverters;
import org.jhotdraw8.geom.FXPathElementsBuilder;

public abstract class AbstractColorSlider
extends Pane {
    public static final int BLOCK_SIZE_COARSE = 32;
    public static final int BLOCK_SIZE_FINE = 2;
    protected final @NonNull DoubleProperty thumbTranslateX = new SimpleDoubleProperty((Object)this, "thumbTranslateX", 0.0);
    protected final @NonNull DoubleProperty thumbTranslateY = new SimpleDoubleProperty((Object)this, "thumbTranslateY", -1.0);
    protected final @NonNull BooleanProperty adjusting = new SimpleBooleanProperty((Object)this, "adjusting");
    protected final @NonNull FloatProperty c0 = new SimpleFloatProperty((Object)this, "c0");
    protected final @NonNull FloatProperty c1 = new SimpleFloatProperty((Object)this, "c1");
    protected final @NonNull FloatProperty c2 = new SimpleFloatProperty((Object)this, "c2");
    protected final @NonNull FloatProperty c3 = new SimpleFloatProperty((Object)this, "c3");
    protected final @NonNull FloatProperty alpha = new SimpleFloatProperty((Object)this, "alpha");
    protected final @NonNull ObjectProperty<NamedColorSpace> targetColorSpace = new SimpleObjectProperty((Object)this, "targetColorSpace");
    protected final @NonNull ObjectProperty<NamedColorSpace> sourceColorSpace = new SimpleObjectProperty((Object)this, "sourceColorSpace");
    protected final @NonNull ObjectProperty<NamedColorSpace> displayColorSpace = new SimpleObjectProperty((Object)this, "displayColorSpace");
    protected final @NonNull ObjectProperty<ToIntFunction<Integer>> rgbFilter = new SimpleObjectProperty((Object)this, "rgbFilter", i -> i);
    protected final @NonNull BooleanProperty snapToTicks = new SimpleBooleanProperty((Object)this, "snapToTicks", true);
    @FXML
    protected Region thumb;
    private @Nullable PixelBuffer<IntBuffer> pixelBuffer;
    private @Nullable CompletableFuture<Void> fillFuture;
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private AnchorPane root;
    @FXML
    private ImageView colorRect;
    private boolean invalid;

    public static @NonNull URL getFxml() {
        String name = "AbstractColorSlider.fxml";
        return Objects.requireNonNull(AbstractColorSlider.class.getResource(name), name);
    }

    public @NonNull BooleanProperty adjustingProperty() {
        return this.adjusting;
    }

    public @NonNull FloatProperty c0Property() {
        return this.c0;
    }

    public @NonNull FloatProperty c1Property() {
        return this.c1;
    }

    public @NonNull FloatProperty c2Property() {
        return this.c2;
    }

    public @NonNull FloatProperty c3Property() {
        return this.c3;
    }

    public @NonNull ObjectProperty<NamedColorSpace> targetColorSpaceProperty() {
        return this.targetColorSpace;
    }

    protected abstract @Nullable AbstractFillTask createFillTask(@NonNull PixelBuffer<IntBuffer> var1);

    protected void drawColorRect() {
        Image newImage;
        PixelBuffer newPixelBuffer;
        boolean resize;
        int width = Math.max(1, (int)this.getWidth());
        int height = Math.max(1, (int)this.getHeight());
        boolean bl = resize = this.pixelBuffer == null || this.pixelBuffer.getWidth() != width || this.pixelBuffer.getHeight() != height;
        if (resize) {
            IntBuffer intBuffer = IntBuffer.allocate(width * height);
            WritablePixelFormat pixelFormat = PixelFormat.getIntArgbPreInstance();
            newPixelBuffer = new PixelBuffer(width, height, (Buffer)intBuffer, (PixelFormat)pixelFormat);
            newImage = new WritableImage(newPixelBuffer);
            this.colorRect.setFitWidth((double)width);
            this.colorRect.setFitHeight((double)height);
            this.invalid = true;
            if (this.fillFuture != null) {
                this.fillFuture.cancel(false);
            }
        } else {
            newImage = this.colorRect.getImage();
            newPixelBuffer = this.pixelBuffer;
        }
        if (this.fillFuture != null) {
            return;
        }
        if (this.invalid) {
            this.invalid = false;
            AbstractFillTask newFillTask = this.createFillTask((PixelBuffer<IntBuffer>)newPixelBuffer);
            if (newFillTask == null) {
                return;
            }
            this.fillFuture = TileTask.fork((int)0, (int)0, (int)width, (int)height, (int)64, (Consumer)newFillTask);
            this.fillFuture.handle((v, e) -> {
                Platform.runLater(() -> {
                    if (e == null) {
                        if (this.colorRect.getImage() != newImage) {
                            this.colorRect.setImage(newImage);
                            this.colorRect.setViewport(null);
                            this.colorRect.setFitWidth(-1.0);
                            this.colorRect.setFitHeight(-1.0);
                        }
                        newPixelBuffer.updateBuffer(b -> null);
                        this.pixelBuffer = newPixelBuffer;
                    } else if (!(e instanceof CancellationException)) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Unexpected Exception " + e.getMessage(), (Throwable)e);
                    }
                    if (this.invalid) {
                        this.requestLayout();
                    }
                    this.fillFuture = null;
                });
                return null;
            });
        }
    }

    public float getC0() {
        return this.c0.get();
    }

    public void setC0(float c0) {
        this.c0.set(c0);
    }

    public float getC1() {
        return this.c1.get();
    }

    public void setC1(float c1) {
        this.c1.set(c1);
    }

    public float getC2() {
        return this.c2.get();
    }

    public void setC2(float c2) {
        this.c2.set(c2);
    }

    public float getC3() {
        return this.c3.get();
    }

    public void setC3(float c3) {
        this.c3.set(c3);
    }

    public NamedColorSpace getTargetColorSpace() {
        return (NamedColorSpace)this.targetColorSpace.get();
    }

    public void setTargetColorSpace(NamedColorSpace targetColorSpace) {
        this.targetColorSpace.set((Object)targetColorSpace);
    }

    public ToIntFunction<Integer> getRgbFilter() {
        return (ToIntFunction)this.rgbFilter.get();
    }

    public void setRgbFilter(ToIntFunction<Integer> rgbFilter) {
        this.rgbFilter.set(rgbFilter);
    }

    @FXML
    void initialize() {
        assert (this.root != null) : "fx:id=\"root\" was not injected: check your FXML file 'AbstractColorSlider.fxml'.";
        assert (this.colorRect != null) : "fx:id=\"sliderArea\" was not injected: check your FXML file 'AbstractColorSlider.fxml'.";
        assert (this.thumb != null) : "fx:id=\"sliderThumb\" was not injected: check your FXML file 'AbstractColorSlider.fxml'.";
        this.colorRect.setPreserveRatio(false);
        this.colorRect.setSmooth(false);
        Path path = new Path();
        FXPathElementsBuilder b = new FXPathElementsBuilder((List)path.getElements());
        b.circle(4.5, 0.0, 0.0);
        b.circle(6.0, 0.0, 0.0);
        path.setFillRule(FillRule.EVEN_ODD);
        this.thumb.setShape((Shape)path);
        this.thumb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)250, (int)250, (int)250), null, null)}));
        this.thumb.setEffect((Effect)new DropShadow(BlurType.THREE_PASS_BOX, Color.BLACK, 2.0, 0.0, 0.0, 1.0));
        this.focusedProperty().addListener((o, oldv, newv) -> {
            if (newv.booleanValue()) {
                this.thumb.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.WHITE, BorderStrokeStyle.SOLID, null, null, new Insets(-1.0, -1.0, -1.0, -1.0))}));
            } else {
                this.thumb.setBorder(null);
            }
        });
        this.setOnMousePressed(this::onMousePressedOrDragged);
        this.setOnMouseDragged(this::onMousePressedOrDragged);
        this.setOnKeyPressed(this::onKeyPressed);
        this.adjustingProperty().addListener(this::onAdjusting);
        InvalidationListener propertyListener = o -> this.requestLayout();
        this.rgbFilterProperty().addListener(propertyListener);
        this.targetColorSpaceProperty().addListener(propertyListener);
        this.sourceColorSpaceProperty().addListener(propertyListener);
        this.displayColorSpaceProperty().addListener(propertyListener);
        this.alphaProperty().addListener(propertyListener);
        this.alphaProperty().addListener(propertyListener);
        this.thumb.setId("color-rect-indicator");
        this.getStyleClass().add((Object)"color-rect-pane");
    }

    protected abstract void onKeyPressed(KeyEvent var1);

    public void invalidate() {
        if (!this.invalid) {
            this.invalid = true;
            this.requestLayout();
        }
    }

    public boolean isAdjusting() {
        return this.adjusting.get();
    }

    public void setAdjusting(boolean adjusting) {
        this.adjusting.set(adjusting);
    }

    public boolean isSnapToTicks() {
        return this.snapToTicks.get();
    }

    public void setSnapToTicks(boolean snapToTicks) {
        this.snapToTicks.set(snapToTicks);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        int width = Math.max(1, (int)this.getWidth());
        int height = Math.max(1, (int)this.getHeight());
        this.invalid |= this.pixelBuffer == null || this.pixelBuffer.getWidth() != width || this.pixelBuffer.getHeight() != height;
        this.validateColorRect();
    }

    protected void load() {
        try {
            FXMLLoader loader = new FXMLLoader(AbstractColorSlider.getFxml());
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.load();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    protected float maybeSnapToTicks(float value, double tickUnit, MouseEvent mouseEvent) {
        return !mouseEvent.isAltDown() && this.isSnapToTicks() ? (float)((double)Math.round((double)value / tickUnit) * tickUnit) : value;
    }

    private void onAdjusting(Observable observable) {
        this.invalidate();
    }

    protected abstract void onMousePressedOrDragged(MouseEvent var1);

    public @NonNull ObjectProperty<ToIntFunction<Integer>> rgbFilterProperty() {
        return this.rgbFilter;
    }

    public @NonNull BooleanProperty snapToTicksProperty() {
        return this.snapToTicks;
    }

    private void validateColorRect() {
        if (this.invalid) {
            this.drawColorRect();
        }
    }

    public NamedColorSpace getDisplayColorSpace() {
        return (NamedColorSpace)this.displayColorSpace.get();
    }

    public @NonNull ObjectProperty<NamedColorSpace> displayColorSpaceProperty() {
        return this.displayColorSpace;
    }

    public void setDisplayColorSpace(NamedColorSpace displayColorSpace) {
        this.displayColorSpace.set((Object)displayColorSpace);
    }

    public double getThumbTranslateX() {
        return this.thumbTranslateX.get();
    }

    public @NonNull DoubleProperty thumbTranslateXProperty() {
        return this.thumbTranslateX;
    }

    protected static boolean outOfGamut(NamedColorSpace colorSpace, float[] component) {
        float epsMin;
        float epsMax;
        if (colorSpace.getType() == 5) {
            epsMax = 9.765625E-4f;
            epsMin = 0.0f;
        } else {
            epsMax = 0.0f;
            epsMin = 0.0f;
        }
        return component[0] < colorSpace.getMinValue(0) - epsMin || component[0] > colorSpace.getMaxValue(0) + epsMax || component[1] < colorSpace.getMinValue(1) - epsMin || component[1] > colorSpace.getMaxValue(1) + epsMax || component[2] < colorSpace.getMinValue(2) - epsMin || component[2] > colorSpace.getMaxValue(2) + epsMax;
    }

    protected static int getPreArgb(NamedColorSpace dcs, float[] dRgb, float[] pre, float alpha) {
        int argb = RgbBitConverters.rgbFloatToPreArgb32((float[])dRgb, (float)alpha, (float[])pre);
        return argb;
    }

    protected static int getArgb(NamedColorSpace scs, NamedColorSpace tcs, NamedColorSpace dcs, float[] colorValue, float[] sRgb, float[] tComponent, float[] dComponent, float[] dRgb, float alpha) {
        scs.toRGB(colorValue, sRgb);
        if (tcs == scs) {
            System.arraycopy(colorValue, 0, tComponent, 0, 3);
        } else {
            tcs.fromRGB(sRgb, tComponent);
        }
        if (dcs == scs) {
            System.arraycopy(colorValue, 0, dComponent, 0, 3);
        } else {
            dcs.fromRGB(sRgb, dComponent);
        }
        boolean outOfDisplay = AbstractColorSlider.outOfGamut(dcs, dComponent);
        boolean outOfTarget = AbstractColorSlider.outOfGamut(tcs, tComponent);
        if (outOfDisplay) {
            // empty if block
        }
        if (!outOfTarget && outOfDisplay) {
            dRgb[0] = 0.5f;
            dRgb[1] = 0.5f;
            dRgb[2] = 0.5f;
        } else if (dcs.getType() == 5) {
            System.arraycopy(dComponent, 0, dRgb, 0, 3);
        } else {
            dcs.toRGB(dComponent, dRgb);
        }
        int argb = RgbBitConverters.rgbFloatToPreArgb32((float[])dRgb, (float)(outOfTarget ? 0.0f : alpha), (float[])dRgb);
        return argb;
    }

    public void setThumbTranslateX(double thumbTranslateX) {
        this.thumbTranslateX.set(thumbTranslateX);
    }

    public double getThumbTranslateY() {
        return this.thumbTranslateY.get();
    }

    public @NonNull DoubleProperty thumbTranslateYProperty() {
        return this.thumbTranslateY;
    }

    public void setThumbTranslateY(double thumbTranslateY) {
        this.thumbTranslateY.set(thumbTranslateY);
    }

    public NamedColorSpace getSourceColorSpace() {
        return (NamedColorSpace)this.sourceColorSpace.get();
    }

    public @NonNull ObjectProperty<NamedColorSpace> sourceColorSpaceProperty() {
        return this.sourceColorSpace;
    }

    public void setSourceColorSpace(NamedColorSpace sourceColorSpace) {
        this.sourceColorSpace.set((Object)sourceColorSpace);
    }

    public float getAlpha() {
        return this.alpha.get();
    }

    public @NonNull FloatProperty alphaProperty() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha.set(alpha);
    }

    public static abstract class AbstractFillTask
    implements Consumer<TileTask.Tile> {
        protected final @NonNull FillTaskRecord record;

        public AbstractFillTask(@NonNull FillTaskRecord record) {
            this.record = record;
        }
    }

    public record FillTaskRecord(@NonNull PixelBuffer<IntBuffer> pixelBuffer, @NonNull NamedColorSpace sourceColorSpace, @NonNull NamedColorSpace targetColorSpace, @NonNull NamedColorSpace displayColorSpace, float c0, float c1, float c2, float c3, int xIndex, int yIndex, float alpha, @NonNull ToIntFunction<Integer> rgbFilter) {
    }
}

