/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.fxbase.binding.Via;
import org.jhotdraw8.fxcontrols.colorchooser.AlphaSlider;
import org.jhotdraw8.fxcontrols.colorchooser.CheckerboardFactory;
import org.jhotdraw8.fxcontrols.colorchooser.ColorChooserPaneModel;

public class AlphaChooser
extends VBox {
    private final @NonNull ObjectProperty<ColorChooserPaneModel> model = new SimpleObjectProperty((Object)this, "model");
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private BorderPane alphaPane;
    private AlphaSlider alphaSlider;

    public ColorChooserPaneModel getModel() {
        return (ColorChooserPaneModel)this.model.get();
    }

    public @NonNull ObjectProperty<ColorChooserPaneModel> modelProperty() {
        return this.model;
    }

    public void setModel(ColorChooserPaneModel model) {
        this.model.set((Object)model);
    }

    public AlphaChooser() {
        this.load();
    }

    private void load() {
        try {
            FXMLLoader loader = new FXMLLoader(AlphaChooser.getFxml());
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.setResources(ResourceBundle.getBundle("org.jhotdraw8.fxcontrols.colorchooser.Labels"));
            loader.load();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    private static URL getFxml() {
        String name = "AlphaChooser.fxml";
        return Objects.requireNonNull(AlphaChooser.class.getResource(name), name);
    }

    @FXML
    void initialize() {
        assert (this.alphaPane != null) : "fx:id=\"alphaPane\" was not injected: check your FXML file 'HlsChooser.fxml'.";
        this.alphaSlider = new AlphaSlider();
        this.alphaPane.setCenter((Node)this.alphaSlider);
        Background checkerboardBackground = new Background(new BackgroundFill[]{new BackgroundFill((Paint)CheckerboardFactory.createCheckerboardPattern(4, -1, -5592406), null, null)});
        this.alphaSlider.setBackground(checkerboardBackground);
        this.alphaSlider.c0Property().bind(this.model.flatMap(ColorChooserPaneModel::c0Property));
        this.alphaSlider.c1Property().bind(this.model.flatMap(ColorChooserPaneModel::c1Property));
        this.alphaSlider.c2Property().bind(this.model.flatMap(ColorChooserPaneModel::c2Property));
        this.alphaSlider.c3Property().bind(this.model.flatMap(ColorChooserPaneModel::c3Property));
        this.alphaSlider.sourceColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::sourceColorSpaceProperty));
        this.alphaSlider.targetColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::targetColorSpaceProperty));
        this.alphaSlider.displayColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayColorSpaceProperty));
        this.alphaSlider.alphaProperty().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::alphaProperty).get());
        this.alphaSlider.rgbFilterProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayBitDepthProperty).map(Map.Entry::getValue));
    }
}

