/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javafx.scene.image.Image;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.paint.ImagePattern;

class CheckerboardFactory {
    private CheckerboardFactory() {
    }

    public static ImagePattern createCheckerboardPattern(int size, int evenArgb, int oddArgb) {
        int width;
        int height = width = size * 2;
        WritablePixelFormat pixelFormat = PixelFormat.getIntArgbPreInstance();
        IntBuffer intBuffer = IntBuffer.allocate(width * height);
        PixelBuffer pixelBuffer = new PixelBuffer(width, height, (Buffer)intBuffer, (PixelFormat)pixelFormat);
        WritableImage image = new WritableImage(pixelBuffer);
        int[] a = intBuffer.array();
        Arrays.fill(a, 0, size, evenArgb);
        Arrays.fill(a, size, size * 2, oddArgb);
        int xy = size * width;
        Arrays.fill(a, xy, xy + size, oddArgb);
        Arrays.fill(a, xy + size, xy + size * 2, evenArgb);
        for (int y = 1; y < size; ++y) {
            xy = width * y;
            System.arraycopy(a, 0, a, xy, width);
            System.arraycopy(a, size * width, a, xy + size * width, width);
        }
        return new ImagePattern((Image)image, 0.0, 0.0, (double)width, (double)height, false);
    }
}

