/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import javafx.beans.Observable;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.converter.FloatConverter;
import org.jhotdraw8.color.A98RgbColorSpace;
import org.jhotdraw8.color.CieLabColorSpace;
import org.jhotdraw8.color.D50XyzColorSpace;
import org.jhotdraw8.color.D65XyzColorSpace;
import org.jhotdraw8.color.DisplayP3ColorSpace;
import org.jhotdraw8.color.NamedColor;
import org.jhotdraw8.color.NamedColorSpace;
import org.jhotdraw8.color.OKHlsColorSpace;
import org.jhotdraw8.color.OKLabColorSpace;
import org.jhotdraw8.color.OKLchColorSpace;
import org.jhotdraw8.color.ParametricHlsColorSpace;
import org.jhotdraw8.color.ParametricHsvColorSpace;
import org.jhotdraw8.color.ParametricLchColorSpace;
import org.jhotdraw8.color.ProPhotoRgbColorSpace;
import org.jhotdraw8.color.Rec2020ColorSpace;
import org.jhotdraw8.color.RgbBitConverters;
import org.jhotdraw8.color.SrgbColorSpace;
import org.jhotdraw8.color.util.MathUtil;

public class ColorChooserPaneModel {
    public static final CieLabColorSpace CIE_LAB_COLOR_SPACE = new CieLabColorSpace();
    public static final ParametricLchColorSpace CIE_LCH_COLOR_SPACE = new ParametricLchColorSpace("CIE LCH", (NamedColorSpace)CIE_LAB_COLOR_SPACE);
    public static final OKLabColorSpace OK_LAB_COLOR_SPACE = new OKLabColorSpace();
    public static final OKLchColorSpace OK_LCH_COLOR_SPACE = new OKLchColorSpace();
    private static final FloatConverter number = new FloatConverter();
    private static final FloatConverter percentageNumber = new FloatConverter();
    public final @NonNull FloatProperty alpha = new SimpleFloatProperty((Object)this, "alpha");
    public final @NonNull FloatProperty c0 = new SimpleFloatProperty((Object)this, "c0");
    public final @NonNull FloatProperty c1 = new SimpleFloatProperty((Object)this, "c1");
    public final @NonNull FloatProperty c2 = new SimpleFloatProperty((Object)this, "c2");
    public final @NonNull FloatProperty hue = new SimpleFloatProperty((Object)this, "hue");
    public final @NonNull FloatProperty hueSliderC0 = new SimpleFloatProperty((Object)this, "hueSliderC0", 0.125f);
    public final @NonNull FloatProperty hueSliderC1 = new SimpleFloatProperty((Object)this, "hueSliderC1", 0.125f);
    public final @NonNull FloatProperty hueSliderC2 = new SimpleFloatProperty((Object)this, "hueSliderC2", 0.5f);
    public final @NonNull FloatProperty chroma = new SimpleFloatProperty((Object)this, "chroma");
    public final @NonNull FloatProperty lightness = new SimpleFloatProperty((Object)this, "lightness");
    public final @NonNull FloatProperty c3 = new SimpleFloatProperty((Object)this, "c3");
    public final @NonNull ObjectProperty<NamedColor> sourceColor = new SimpleObjectProperty((Object)this, "chooserColor");
    public final @NonNull ObjectProperty<ChooserType> chooserType = new SimpleObjectProperty((Object)this, "ChooserType");
    public final @NonNull ListProperty<ChooserType> chooserTypes = new SimpleListProperty((Object)this, "ChooserTypes", FXCollections.observableArrayList());
    public final @NonNull ObjectProperty<Map.Entry<String, ToIntFunction<Integer>>> displayBitDepth = new SimpleObjectProperty((Object)this, "displayBitDepth");
    public final @NonNull ListProperty<Map.Entry<String, ToIntFunction<Integer>>> displayBitDepths = new SimpleListProperty((Object)this, "displayBitDepths", FXCollections.observableArrayList());
    public final @NonNull ObjectProperty<NamedColor> displayColor = new SimpleObjectProperty((Object)this, "displayColor");
    public final @NonNull ObjectProperty<NamedColorSpace> displayColorSpace = new SimpleObjectProperty((Object)this, "displayColorSpace");
    public final @NonNull ListProperty<NamedColorSpace> displayColorSpaces = new SimpleListProperty((Object)this, "displayColorSpaces", FXCollections.observableArrayList());
    public final @NonNull ObjectProperty<Color> previewColor = new SimpleObjectProperty((Object)this, "previewColor");
    public final @NonNull StringProperty sourceColorField = new SimpleStringProperty((Object)this, "sourceColorField");
    public final @NonNull StringProperty targetColorField = new SimpleStringProperty((Object)this, "targetColorField");
    public final @NonNull StringProperty displayColorField = new SimpleStringProperty((Object)this, "displayColorField");
    public final @NonNull ObjectProperty<NamedColorSpace> sourceColorSpace = new SimpleObjectProperty((Object)this, "chooserColorSpace");
    public final @NonNull IntegerProperty sourceColorSpaceHueIndex = new SimpleIntegerProperty((Object)this, "sourceColorSpaceHueIndex");
    public final @NonNull IntegerProperty sourceColorSpaceLightnessValueIndex = new SimpleIntegerProperty((Object)this, "sourceColorSpaceLightnessValueIndex");
    public final @NonNull IntegerProperty sourceColorSpaceSaturationChromaIndex = new SimpleIntegerProperty((Object)this, "sourceColorSpaceSaturationChromaIndex");
    public final @NonNull ObjectProperty<NamedColor> targetColor = new SimpleObjectProperty((Object)this, "targetColor");
    public final @NonNull ObjectProperty<NamedColorSpace> targetColorSpace = new SimpleObjectProperty((Object)this, "targetColorSpace");
    public final @NonNull ListProperty<NamedColorSpace> targetColorSpaces = new SimpleListProperty((Object)this, "targetColorSpaces", FXCollections.observableArrayList());
    public final @NonNull ObjectProperty<ColorSyntax> targetColorSyntax = new SimpleObjectProperty((Object)this, "ColorSyntax");
    public final @NonNull ListProperty<ColorSyntax> targetColorSyntaxes = new SimpleListProperty((Object)this, "ColorSyntaxes", FXCollections.observableArrayList());
    private static final SrgbColorSpace SRGB_COLOR_SPACE = new SrgbColorSpace();
    private static final ParametricHlsColorSpace HLS_COLOR_SPACE = new ParametricHlsColorSpace("HSL", (NamedColorSpace)SRGB_COLOR_SPACE);
    private static final ParametricHsvColorSpace HSV_COLOR_SPACE = new ParametricHsvColorSpace("HSV", (NamedColorSpace)SRGB_COLOR_SPACE);
    private static final Map<String, String> colorSpaceNameMap = Map.of("Display P3", "display-p3", "sRGB", "srgb", "sRGB Linear", "srgb-linear", "display-p3", "display-p3", "a98-rgb", "a98-rgb", "ProPhoto RGB", "prophoto-rgb", "Rec 2020", "rec2020", "xyz", "xyz", "xyz-d50", "xyz-d50", "xyz-d65", "xyz-d65");

    public ColorChooserPaneModel() {
        this.sourceColorSpace.addListener(this::updateSourceColorSpaceProperties);
        this.chooserType.addListener(this::updateSourceColorSpace);
        this.targetColorSpace.addListener(this::updateSourceColorSpace);
        ChangeListener changeListener = (o, oldv, newv) -> {
            this.updateDisplayColor((Observable)o, oldv, newv);
            this.updateTargetColorField((Observable)o, oldv, newv);
            this.updateSourceColorField((Observable)o, oldv, newv);
        };
        this.c0.addListener(changeListener);
        this.c1.addListener(changeListener);
        this.c2.addListener(changeListener);
        this.c3.addListener(changeListener);
        this.alpha.addListener(changeListener);
        this.targetColorSpace.addListener(changeListener);
        this.displayColorSpace.addListener(changeListener);
        this.displayBitDepth.addListener(changeListener);
        this.targetColorSyntax.addListener(changeListener);
    }

    public @NonNull FloatProperty alphaProperty() {
        return this.alpha;
    }

    public @NonNull FloatProperty c0Property() {
        return this.c0;
    }

    public @NonNull FloatProperty c1Property() {
        return this.c1;
    }

    public @NonNull FloatProperty c2Property() {
        return this.c2;
    }

    public @NonNull FloatProperty c3Property() {
        return this.c3;
    }

    public @NonNull ObjectProperty<NamedColor> sourceColorProperty() {
        return this.sourceColor;
    }

    public @NonNull ObjectProperty<ChooserType> chooserTypeProperty() {
        return this.chooserType;
    }

    public @NonNull ListProperty<ChooserType> colorChoosersProperty() {
        return this.chooserTypes;
    }

    public @NonNull ObjectProperty<Map.Entry<String, ToIntFunction<Integer>>> displayBitDepthProperty() {
        return this.displayBitDepth;
    }

    public @NonNull ListProperty<Map.Entry<String, ToIntFunction<Integer>>> displayBitDepthsProperty() {
        return this.displayBitDepths;
    }

    public @NonNull ObjectProperty<NamedColor> displayColorProperty() {
        return this.displayColor;
    }

    public @NonNull ObjectProperty<NamedColorSpace> displayColorSpaceProperty() {
        return this.displayColorSpace;
    }

    public @NonNull ListProperty<NamedColorSpace> displayColorSpacesProperty() {
        return this.displayColorSpaces;
    }

    public float getAlpha() {
        return this.alpha.get();
    }

    public void setAlpha(float alpha) {
        this.alpha.set(alpha);
    }

    public float getC0() {
        return this.c0.get();
    }

    public void setC0(float c0) {
        this.c0.set(c0);
    }

    public float getC1() {
        return this.c1.get();
    }

    public void setC1(float c1) {
        this.c1.set(c1);
    }

    public float getC2() {
        return this.c2.get();
    }

    public void setC2(float c2) {
        this.c2.set(c2);
    }

    public float getC3() {
        return this.c3.get();
    }

    public void setC3(float c3) {
        this.c3.set(c3);
    }

    public NamedColor getSourceColor() {
        return (NamedColor)this.sourceColor.get();
    }

    public void setSourceColor(NamedColor sourceColor) {
        this.sourceColor.set((Object)sourceColor);
    }

    public ChooserType getChooserType() {
        return (ChooserType)((Object)this.chooserType.get());
    }

    public void setChooserType(ChooserType chooserType) {
        this.chooserType.set((Object)chooserType);
    }

    public ObservableList<ChooserType> getColorChoosers() {
        return (ObservableList)this.chooserTypes.get();
    }

    public void setColorChoosers(ObservableList<ChooserType> chooserTypes) {
        this.chooserTypes.set(chooserTypes);
    }

    public Map.Entry<String, ToIntFunction<Integer>> getDisplayBitDepth() {
        return (Map.Entry)this.displayBitDepth.get();
    }

    public void setDisplayBitDepth(Map.Entry<String, ToIntFunction<Integer>> displayBitDepth) {
        this.displayBitDepth.set(displayBitDepth);
    }

    public ObservableList<Map.Entry<String, ToIntFunction<Integer>>> getDisplayBitDepths() {
        return (ObservableList)this.displayBitDepths.get();
    }

    public void setDisplayBitDepths(ObservableList<Map.Entry<String, ToIntFunction<Integer>>> displayBitDepths) {
        this.displayBitDepths.set(displayBitDepths);
    }

    public NamedColor getDisplayColor() {
        return (NamedColor)this.displayColor.get();
    }

    public void setDisplayColor(NamedColor displayColor) {
        this.displayColor.set((Object)displayColor);
    }

    public NamedColorSpace getDisplayColorSpace() {
        return (NamedColorSpace)this.displayColorSpace.get();
    }

    public void setDisplayColorSpace(NamedColorSpace displayColorSpace) {
        this.displayColorSpace.set((Object)displayColorSpace);
    }

    public ObservableList<NamedColorSpace> getDisplayColorSpaces() {
        return (ObservableList)this.displayColorSpaces.get();
    }

    public void setDisplayColorSpaces(ObservableList<NamedColorSpace> displayColorSpaces) {
        this.displayColorSpaces.set(displayColorSpaces);
    }

    public Color getPreviewColor() {
        return (Color)this.previewColor.get();
    }

    public void setPreviewColor(Color previewColor) {
        this.previewColor.set((Object)previewColor);
    }

    public String getSourceColorField() {
        return (String)this.sourceColorField.get();
    }

    public void setSourceColorField(String sourceColorField) {
        this.sourceColorField.set((Object)sourceColorField);
    }

    public NamedColorSpace getSourceColorSpace() {
        return (NamedColorSpace)this.sourceColorSpace.get();
    }

    public void setSourceColorSpace(NamedColorSpace sourceColorSpace) {
        this.sourceColorSpace.set((Object)sourceColorSpace);
    }

    public int getSourceColorSpaceHueIndex() {
        return this.sourceColorSpaceHueIndex.get();
    }

    public void setSourceColorSpaceHueIndex(int sourceColorSpaceHueIndex) {
        this.sourceColorSpaceHueIndex.set(sourceColorSpaceHueIndex);
    }

    public int getSourceColorSpaceLightnessValueIndex() {
        return this.sourceColorSpaceLightnessValueIndex.get();
    }

    public void setSourceColorSpaceLightnessValueIndex(int sourceColorSpaceLightnessValueIndex) {
        this.sourceColorSpaceLightnessValueIndex.set(sourceColorSpaceLightnessValueIndex);
    }

    public int getSourceColorSpaceSaturationChromaIndex() {
        return this.sourceColorSpaceSaturationChromaIndex.get();
    }

    public void setSourceColorSpaceSaturationChromaIndex(int sourceColorSpaceSaturationChromaIndex) {
        this.sourceColorSpaceSaturationChromaIndex.set(sourceColorSpaceSaturationChromaIndex);
    }

    public NamedColor getTargetColor() {
        return (NamedColor)this.targetColor.get();
    }

    public void setTargetColor(NamedColor targetColor) {
        this.targetColor.set((Object)targetColor);
    }

    public NamedColorSpace getTargetColorSpace() {
        return (NamedColorSpace)this.targetColorSpace.get();
    }

    public void setTargetColorSpace(NamedColorSpace targetColorSpace) {
        this.targetColorSpace.set((Object)targetColorSpace);
    }

    public ObservableList<NamedColorSpace> getTargetColorSpaces() {
        return (ObservableList)this.targetColorSpaces.get();
    }

    public void setTargetColorSpaces(ObservableList<NamedColorSpace> targetColorSpaces) {
        this.targetColorSpaces.set(targetColorSpaces);
    }

    public ColorSyntax getTargetColorSyntax() {
        return (ColorSyntax)((Object)this.targetColorSyntax.get());
    }

    public void setTargetColorSyntax(ColorSyntax targetColorSyntax) {
        this.targetColorSyntax.set((Object)targetColorSyntax);
    }

    public ObservableList<ColorSyntax> getTargetColorSyntaxes() {
        return (ObservableList)this.targetColorSyntaxes.get();
    }

    public void setTargetColorSyntaxes(ObservableList<ColorSyntax> targetColorSyntaxes) {
        this.targetColorSyntaxes.set(targetColorSyntaxes);
    }

    public void initWithDefaultValues() {
        DisplayP3ColorSpace displayP3ColorSpace = new DisplayP3ColorSpace();
        ProPhotoRgbColorSpace proPhotoRgbColorSpace = new ProPhotoRgbColorSpace();
        Rec2020ColorSpace rec2020ColorSpace = new Rec2020ColorSpace();
        ((ObservableList)this.displayColorSpaces.get()).setAll((Object[])new NamedColorSpace[]{SRGB_COLOR_SPACE, displayP3ColorSpace, rec2020ColorSpace, proPhotoRgbColorSpace});
        ((ObservableList)this.targetColorSpaces.get()).setAll((Object[])new NamedColorSpace[]{SRGB_COLOR_SPACE, SRGB_COLOR_SPACE.getLinearColorSpace(), displayP3ColorSpace, new A98RgbColorSpace(), proPhotoRgbColorSpace, rec2020ColorSpace, new D50XyzColorSpace(), new D65XyzColorSpace(), OK_LAB_COLOR_SPACE, CIE_LAB_COLOR_SPACE});
        ((ObservableList)this.targetColorSyntaxes.get()).setAll((Object[])ColorSyntax.values());
        this.targetColorSyntax.set((Object)ColorSyntax.HEX_COLOR);
        ((ObservableList)this.chooserTypes.get()).setAll((Object[])ChooserType.values());
        this.chooserType.set((Object)ChooserType.OK_HSL_SRGB);
        this.displayColorSpace.set((Object)SRGB_COLOR_SPACE);
        this.targetColorSpace.set((Object)SRGB_COLOR_SPACE);
        this.alpha.set(1.0f);
        LinkedHashMap<String, ToIntFunction<Integer>> map = new LinkedHashMap<String, ToIntFunction<Integer>>();
        map.put("24", argb -> argb);
        map.put("16", argb -> argb & 0xFF000000 | RgbBitConverters.rgb16to24((int)RgbBitConverters.rgb24to16((int)argb)));
        map.put("15", argb -> argb & 0xFF000000 | RgbBitConverters.rgb15to24((int)RgbBitConverters.rgb24to15((int)argb)));
        map.put("12", argb -> argb & 0xFF000000 | RgbBitConverters.rgb12to24((int)RgbBitConverters.rgb24to12((int)argb)));
        map.put("6", argb -> argb & 0xFF000000 | RgbBitConverters.rgb6to24((int)RgbBitConverters.rgb24to6((int)argb)));
        ((ObservableList)this.displayBitDepths.get()).setAll(map.entrySet());
        this.displayBitDepth.set(new AbstractMap.SimpleImmutableEntry<String, ToIntFunction<Integer>>("24", argb -> argb));
    }

    public @NonNull ObjectProperty<Color> previewColorProperty() {
        return this.previewColor;
    }

    public @NonNull StringProperty sourceColorFieldProperty() {
        return this.sourceColorField;
    }

    public void setComponent(int i, float value) {
        switch (i) {
            case 0: {
                this.c0.set(value);
                break;
            }
            case 1: {
                this.c1.set(value);
                break;
            }
            case 2: {
                this.c2.set(value);
                break;
            }
            default: {
                this.c3.setValue((Number)Float.valueOf(value));
            }
        }
    }

    public float getComponent(int i) {
        return switch (i) {
            case 0 -> this.c0.get();
            case 1 -> this.c1.get();
            case 2 -> this.c2.get();
            default -> this.c3.getValue().floatValue();
        };
    }

    public @NonNull IntegerProperty sourceColorSpaceHueIndexProperty() {
        return this.sourceColorSpaceHueIndex;
    }

    public @NonNull IntegerProperty sourceColorSpaceLightnessValueIndexProperty() {
        return this.sourceColorSpaceLightnessValueIndex;
    }

    public @NonNull ObjectProperty<NamedColorSpace> sourceColorSpaceProperty() {
        return this.sourceColorSpace;
    }

    public @NonNull IntegerProperty sourceColorSpaceSaturationChromaIndexProperty() {
        return this.sourceColorSpaceSaturationChromaIndex;
    }

    public @NonNull ObjectProperty<NamedColor> targetColorProperty() {
        return this.targetColor;
    }

    public @NonNull ObjectProperty<NamedColorSpace> targetColorSpaceProperty() {
        return this.targetColorSpace;
    }

    public @NonNull ListProperty<NamedColorSpace> targetColorSpacesProperty() {
        return this.targetColorSpaces;
    }

    public @NonNull ObjectProperty<ColorSyntax> targetColorSyntaxProperty() {
        return this.targetColorSyntax;
    }

    public @NonNull ListProperty<ColorSyntax> targetColorSyntaxesProperty() {
        return this.targetColorSyntaxes;
    }

    private void updateSourceColorField(Observable o, Object oldv, Object newv) {
        String text = this.toCssString(this.getSourceColorSpace(), this.getC0(), this.getC1(), this.getC2(), this.getAlpha(), ColorSyntax.AUTOMATIC);
        this.setSourceColorField(text);
    }

    private void updateTargetColorField(Observable o, Object oldv, Object newv) {
        NamedColorSpace tcs = this.getTargetColorSpace();
        switch (this.getTargetColorSyntax().ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 8: {
                tcs = CIE_LAB_COLOR_SPACE;
                break;
            }
            case 7: {
                tcs = OK_LAB_COLOR_SPACE;
                break;
            }
            case 9: {
                tcs = OK_LCH_COLOR_SPACE;
            }
        }
        NamedColorSpace scs = this.getSourceColorSpace();
        if (tcs != null && scs != null) {
            float[] sComponent = new float[]{this.getC0(), this.getC1(), this.getC2()};
            float[] tComponent = tcs != scs ? tcs.fromCIEXYZ(scs.toCIEXYZ(sComponent)) : sComponent;
            String text = this.toCssString(tcs, tComponent[0], tComponent[1], tComponent[2], this.getAlpha(), this.getTargetColorSyntax());
            this.setTargetColorField(text);
        }
    }

    private @NonNull String toCssString(NamedColorSpace cs, float c0, float c1, float c2, float alpha, ColorSyntax colorSyntax) {
        StringBuilder b = new StringBuilder();
        if (cs == null) {
            b.append("none");
            return b.toString();
        }
        if (colorSyntax == ColorSyntax.AUTOMATIC) {
            switch (cs.getType()) {
                case 32: {
                    colorSyntax = cs instanceof OKLchColorSpace ? ColorSyntax.OKLCH_FUNCTION : ColorSyntax.LCH_FUNCTION;
                    break;
                }
                case 8: {
                    colorSyntax = ColorSyntax.HSL_FUNCTION;
                    break;
                }
                case 1: {
                    colorSyntax = cs instanceof OKLabColorSpace ? ColorSyntax.OKLAB_FUNCTION : ColorSyntax.LAB_FUNCTION;
                    break;
                }
                default: {
                    colorSyntax = ColorSyntax.COLOR_FUNCTION;
                }
            }
        }
        float[] components = new float[]{c0, c1, c2};
        switch (colorSyntax.ordinal()) {
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                cs.toRGB(components, components);
                break;
            }
            case 4: {
                ParametricHlsColorSpace hlsc;
                if (cs.getType() == 8 && (!(cs instanceof ParametricHlsColorSpace) || (hlsc = (ParametricHlsColorSpace)cs).getRgbColorSpace().getName().equals("sRGB"))) break;
                HLS_COLOR_SPACE.fromCIEXYZ(cs.toCIEXYZ(components, components), components);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                if (cs.getType() == 1 && !(cs instanceof OKLabColorSpace)) break;
                CIE_LAB_COLOR_SPACE.fromCIEXYZ(cs.toCIEXYZ(components, components), components);
                break;
            }
            case 7: {
                if (cs instanceof OKLabColorSpace) break;
                CIE_LAB_COLOR_SPACE.fromCIEXYZ(cs.toCIEXYZ(components, components), components);
                break;
            }
            case 8: {
                if (cs instanceof OKLchColorSpace) break;
                OK_LCH_COLOR_SPACE.fromCIEXYZ(cs.toCIEXYZ(components, components), components);
                break;
            }
        }
        for (int i = 0; i < components.length; ++i) {
            if (!(Math.abs(components[i]) < 1.0E-5f)) continue;
            components[i] = 0.0f;
        }
        switch (colorSyntax.ordinal()) {
            case 1: 
            case 2: {
                Map.Entry entry = (Map.Entry)this.displayBitDepth.get();
                int value = RgbBitConverters.rgbFloatToArgb32((float[])components, (float)alpha);
                int argb = entry == null ? value : ((ToIntFunction)entry.getValue()).applyAsInt(value);
                Object hexStr = "00000000" + Integer.toHexString(argb);
                hexStr = ((String)hexStr).substring(((String)hexStr).length() - 8);
                b.append((String)hexStr);
                break;
            }
            case 3: {
                b.append("rgb(");
                components[0] = Math.round(255.0f * components[0]);
                components[1] = Math.round(255.0f * components[1]);
                components[2] = Math.round(255.0f * components[2]);
                break;
            }
            case 4: {
                if (cs instanceof OKHlsColorSpace) {
                    b.append("okhsl(");
                } else {
                    b.append("hsl(");
                }
                b.append(number.toString((Object)Float.valueOf(components[0])));
                b.append(' ');
                b.append(percentageNumber.toString((Object)Float.valueOf(components[1] * 100.0f)));
                b.append("% ");
                b.append(percentageNumber.toString((Object)Float.valueOf(components[2] * 100.0f)));
                b.append("% / ");
                b.append(number.toString((Object)Float.valueOf(alpha * 100.0f)));
                b.append("%)");
                break;
            }
            case 5: {
                b.append("hwb(");
                break;
            }
            case 6: {
                b.append("lab(");
                break;
            }
            case 7: {
                b.append("oklab(");
                break;
            }
            case 8: {
                b.append("lch(");
                break;
            }
            case 9: {
                b.append("oklch(");
                break;
            }
            case 10: {
                b.append("color(");
                b.append(colorSpaceNameMap.get(cs.getName()));
                b.append(' ');
                break;
            }
            default: {
                b.append("color(\"");
                b.append(cs.getName());
                b.append("\" ");
            }
        }
        switch (colorSyntax.ordinal()) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                b.append(number.toString((Object)Float.valueOf(components[0])));
                b.append(' ');
                b.append(number.toString((Object)Float.valueOf(components[1])));
                b.append(' ');
                b.append(number.toString((Object)Float.valueOf(components[2])));
                b.append(" / ");
                b.append(number.toString((Object)Float.valueOf(alpha * 100.0f)));
                b.append("%)");
            }
        }
        return b.toString();
    }

    private void updateSourceColorSpace(Observable o, Object oldv, Object newv) {
        ChooserType ct = (ChooserType)((Object)this.chooserType.get());
        NamedColorSpace tcs = (NamedColorSpace)this.targetColorSpace.get();
        if (ct == null || tcs == null) {
            this.sourceColorSpace.set(null);
            return;
        }
        NamedColorSpace oldScs = (NamedColorSpace)this.sourceColorSpace.get();
        switch (ct.ordinal()) {
            case 0: {
                this.sourceColorSpace.set((Object)new OKHlsColorSpace());
                break;
            }
            case 1: 
            case 2: {
                this.sourceColorSpace.set((Object)tcs);
                break;
            }
            case 3: {
                Object cs = tcs.getType() == 5 ? tcs : new SrgbColorSpace();
                this.sourceColorSpace.set((Object)new ParametricHlsColorSpace(cs.getName() + " HSL", cs));
                break;
            }
            case 4: {
                Object cs = tcs.getType() == 5 ? tcs : new SrgbColorSpace();
                this.sourceColorSpace.set((Object)new ParametricHsvColorSpace(cs.getName() + " HSV", cs));
                break;
            }
            case 6: {
                this.sourceColorSpace.set((Object)CIE_LCH_COLOR_SPACE);
                break;
            }
            case 5: {
                this.sourceColorSpace.set((Object)new OKLchColorSpace());
                break;
            }
            default: {
                this.sourceColorSpace.set((Object)tcs);
                this.hueSliderC0.set(0.5f);
                this.hueSliderC1.set(0.5f);
            }
        }
        NamedColorSpace newScs = (NamedColorSpace)this.sourceColorSpace.get();
        if (newScs instanceof OKLchColorSpace) {
            this.hueSliderC0.set(0.75f);
            this.hueSliderC1.set(0.12f);
            this.hueSliderC2.set(0.5f);
        } else {
            this.hueSliderC0.set(0.5f * (newScs.getMaxValue(0) - newScs.getMinValue(0)) + newScs.getMinValue(0));
            this.hueSliderC1.set(0.5f * (newScs.getMaxValue(1) - newScs.getMinValue(1)) + newScs.getMinValue(1));
            this.hueSliderC2.set(0.5f * (newScs.getMaxValue(2) - newScs.getMinValue(2)) + newScs.getMinValue(2));
        }
        if (oldScs != null) {
            float[] oldComponents = new float[]{this.getC0(), this.getC1(), this.getC2()};
            float[] xyz = oldScs.toCIEXYZ(oldComponents);
            float[] newComponents = newScs.fromCIEXYZ(xyz);
            this.setC0(newComponents[0]);
            this.setC1(newComponents[1]);
            this.setC2(newComponents[2]);
        }
    }

    private void updateSourceColorSpaceProperties(Observable o, Object oldv, Object newv) {
        NamedColorSpace ncs = (NamedColorSpace)this.sourceColorSpace.get();
        if (ncs == null) {
            return;
        }
        this.hue.unbindBidirectional((Property)this.c0);
        this.hue.unbindBidirectional((Property)this.c1);
        this.hue.unbindBidirectional((Property)this.c2);
        this.chroma.unbindBidirectional((Property)this.c0);
        this.chroma.unbindBidirectional((Property)this.c1);
        this.chroma.unbindBidirectional((Property)this.c2);
        this.lightness.unbindBidirectional((Property)this.c0);
        this.lightness.unbindBidirectional((Property)this.c1);
        this.lightness.unbindBidirectional((Property)this.c2);
        switch (ncs.getType()) {
            default: {
                this.sourceColorSpaceHueIndex.set(0);
                this.sourceColorSpaceSaturationChromaIndex.set(1);
                this.sourceColorSpaceLightnessValueIndex.set(2);
                this.hue.bindBidirectional((Property)this.c0);
                this.lightness.bindBidirectional((Property)this.c1);
                this.chroma.bindBidirectional((Property)this.c2);
                break;
            }
            case 8: {
                this.sourceColorSpaceHueIndex.set(0);
                this.sourceColorSpaceSaturationChromaIndex.set(2);
                this.sourceColorSpaceLightnessValueIndex.set(1);
                this.hue.bindBidirectional((Property)this.c0);
                this.lightness.bindBidirectional((Property)this.c1);
                this.chroma.bindBidirectional((Property)this.c2);
                break;
            }
            case 32: {
                this.sourceColorSpaceHueIndex.set(2);
                this.sourceColorSpaceSaturationChromaIndex.set(1);
                this.sourceColorSpaceLightnessValueIndex.set(0);
                this.lightness.bindBidirectional((Property)this.c0);
                this.chroma.bindBidirectional((Property)this.c1);
                this.hue.bindBidirectional((Property)this.c2);
            }
        }
    }

    private void updateDisplayColor(Observable o, Object oldv, Object newv) {
        float[] component = new float[]{this.c0.floatValue(), this.c1.floatValue(), this.c2.floatValue()};
        float[] rgb = new float[3];
        NamedColorSpace displayCs = (NamedColorSpace)this.displayColorSpace.get();
        NamedColorSpace sourceCs = (NamedColorSpace)this.sourceColorSpace.get();
        NamedColorSpace targetCs = (NamedColorSpace)this.targetColorSpace.get();
        if (displayCs == null || targetCs == null) {
            return;
        }
        Map.Entry entry = (Map.Entry)this.displayBitDepth.get();
        displayCs.fromRGB(sourceCs.toRGB(component, rgb), rgb);
        int value = RgbBitConverters.rgbFloatToArgb32((float[])rgb, (float)this.alpha.floatValue());
        int argb = entry == null ? value : ((ToIntFunction)entry.getValue()).applyAsInt(value);
        Color previewColorValue = Color.rgb((int)(argb >>> 16 & 0xFF), (int)(argb >>> 8 & 0xFF), (int)(argb & 0xFF), (double)MathUtil.clamp((float)this.alpha.floatValue(), (float)0.0f, (float)1.0f));
        Object hexStr = "00000000" + Integer.toHexString(argb);
        hexStr = ((String)hexStr).substring(((String)hexStr).length() - 8);
        this.previewColor.set((Object)previewColorValue);
        this.setDisplayColorField("#" + (String)hexStr);
    }

    public String getTargetColorField() {
        return (String)this.targetColorField.get();
    }

    public @NonNull StringProperty targetColorFieldProperty() {
        return this.targetColorField;
    }

    public void setTargetColorField(String targetColorField) {
        this.targetColorField.set((Object)targetColorField);
    }

    public String getDisplayColorField() {
        return (String)this.displayColorField.get();
    }

    public @NonNull StringProperty displayColorFieldProperty() {
        return this.displayColorField;
    }

    public void setDisplayColorField(String displayColorField) {
        this.displayColorField.set((Object)displayColorField);
    }

    public float getHue() {
        return this.hue.get();
    }

    public @NonNull FloatProperty hueProperty() {
        return this.hue;
    }

    public void setHue(float hue) {
        this.hue.set(hue);
    }

    public float getChroma() {
        return this.chroma.get();
    }

    public @NonNull FloatProperty chromaProperty() {
        return this.chroma;
    }

    public void setChroma(float chroma) {
        this.chroma.set(chroma);
    }

    public float getLightness() {
        return this.lightness.get();
    }

    public @NonNull FloatProperty lightnessProperty() {
        return this.lightness;
    }

    public void setLightness(float lightness) {
        this.lightness.set(lightness);
    }

    public float getHueSliderC0() {
        return this.hueSliderC0.get();
    }

    public @NonNull FloatProperty hueSliderC0Property() {
        return this.hueSliderC0;
    }

    public void setHueSliderC0(float lightness) {
        this.hueSliderC0.set(lightness);
    }

    public float getHueSliderC1() {
        return this.hueSliderC1.get();
    }

    public @NonNull FloatProperty hueSliderC1Property() {
        return this.hueSliderC1;
    }

    public void setHueSliderC1(float hueSliderC1) {
        this.hueSliderC1.set(hueSliderC1);
    }

    public float getHueSliderC2() {
        return this.hueSliderC2.get();
    }

    public @NonNull FloatProperty hueSliderC2Property() {
        return this.hueSliderC2;
    }

    public void setHueSliderC2(float hueSliderC2) {
        this.hueSliderC2.set(hueSliderC2);
    }

    public static enum ChooserType {
        OK_HSL_SRGB,
        SLIDERS,
        SWATCHES,
        HSL,
        HSV,
        OK_LCH,
        CIE_LCH;

    }

    public static enum ColorSyntax {
        AUTOMATIC,
        HEX_COLOR,
        NAMED_COLOR,
        RGB_FUNCTION,
        HSL_FUNCTION,
        HWB_FUNCTION,
        LAB_FUNCTION,
        OKLAB_FUNCTION,
        LCH_FUNCTION,
        OKLCH_FUNCTION,
        COLOR_FUNCTION;

    }
}

