/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxcontrols.colorchooser.ColorSpaceColor;

public class ColorDialog
extends HBox {
    private final @NonNull Stage dialog = new Stage();
    private Runnable onSave;
    private Runnable onUse;
    private Runnable onCancel;
    private final @NonNull ObjectProperty<ColorSpaceColor> currentColor = new SimpleObjectProperty((Object)ColorSpaceColor.WHITE);
    private final @NonNull ObjectProperty<ColorSpaceColor> customColor = new SimpleObjectProperty((Object)ColorSpaceColor.TRANSPARENT);
    private final EventHandler<KeyEvent> keyEventListener = e -> {
        switch (e.getCode()) {
            case ESCAPE: {
                this.dialog.setScene(null);
                this.dialog.close();
                break;
            }
        }
    };

    public ColorDialog() {
    }

    public ColorDialog(@Nullable Window owner) {
        if (owner != null) {
            this.dialog.initOwner(owner);
        }
        this.dialog.initModality(Modality.WINDOW_MODAL);
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.setResizable(false);
        this.dialog.addEventHandler(KeyEvent.ANY, this.keyEventListener);
    }

    public Runnable getOnSave() {
        return this.onSave;
    }

    public void setOnSave(Runnable onSave) {
        this.onSave = onSave;
    }

    public Runnable getOnUse() {
        return this.onUse;
    }

    public void setOnUse(Runnable onUse) {
        this.onUse = onUse;
    }

    public Runnable getOnCancel() {
        return this.onCancel;
    }

    public void setOnCancel(Runnable onCancel) {
        this.onCancel = onCancel;
    }

    public ColorSpaceColor getCurrentColor() {
        return (ColorSpaceColor)this.currentColor.get();
    }

    public @NonNull ObjectProperty<ColorSpaceColor> currentColorProperty() {
        return this.currentColor;
    }

    public void setCurrentColor(ColorSpaceColor currentColor) {
        this.currentColor.set((Object)currentColor);
    }

    public ColorSpaceColor getCustomColor() {
        return (ColorSpaceColor)this.customColor.get();
    }

    public @NonNull ObjectProperty<ColorSpaceColor> customColorProperty() {
        return this.customColor;
    }

    public void setCustomColor(ColorSpaceColor customColor) {
        this.customColor.set((Object)customColor);
    }

    public void show() {
        this.dialog.show();
    }
}

