/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import java.nio.IntBuffer;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.image.PixelBuffer;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.concurrent.TileTask;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.color.NamedColorSpace;
import org.jhotdraw8.fxcontrols.colorchooser.AbstractColorSlider;

public class ColorRectangleSlider
extends AbstractColorSlider {
    private final @NonNull IntegerProperty xComponentIndex = new SimpleIntegerProperty((Object)this, "xComponentIndex", 1);
    private final @NonNull IntegerProperty yComponentIndex = new SimpleIntegerProperty((Object)this, "yComponentIndex", 2);
    private final @NonNull DoubleProperty xMinorTickUnit = new SimpleDoubleProperty((Object)this, "xMinorTickUnit", 0.003921568859368563);
    private final @NonNull DoubleProperty yMinorTickUnit = new SimpleDoubleProperty((Object)this, "yMinorTickUnit", 0.003921568859368563);
    private final @NonNull DoubleProperty xMajorTickUnit = new SimpleDoubleProperty((Object)this, "xMajorTickUnit", 0.003921568859368563);
    private final @NonNull DoubleProperty yMajorTickUnit = new SimpleDoubleProperty((Object)this, "yMajorTickUnit", 0.003921568859368563);
    private final @NonNull FloatProperty xValue = new SimpleFloatProperty((Object)this, "xValue", 0.0f);
    private final @NonNull FloatProperty yValue = new SimpleFloatProperty((Object)this, "yValue", 0.0f);

    public ColorRectangleSlider() {
        this.load();
    }

    @Override
    void initialize() {
        super.initialize();
        this.c0Property().addListener(o -> this.onComponentValueChanged(0));
        this.c1Property().addListener(o -> this.onComponentValueChanged(1));
        this.c2Property().addListener(o -> this.onComponentValueChanged(2));
        this.c3Property().addListener(o -> this.onComponentValueChanged(3));
        this.xValue.addListener(o -> this.requestLayout());
        this.yValue.addListener(o -> this.requestLayout());
        this.xComponentIndex.addListener(o -> this.invalidate());
        this.xComponentIndex.addListener(o -> this.invalidate());
        this.alpha.addListener(o -> this.invalidate());
    }

    private void onComponentValueChanged(int i) {
        if (i != this.getXComponentIndex() && i != this.getYComponentIndex()) {
            this.invalidate();
        }
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        NamedColorSpace cs = this.getSourceColorSpace();
        if (cs == null) {
            return;
        }
        double width = this.getWidth();
        double height = this.getHeight();
        float xmax = cs.getMaxValue(this.xComponentIndex.get());
        float xmin = cs.getMinValue(this.xComponentIndex.get());
        float ymax = cs.getMaxValue(this.yComponentIndex.get());
        float ymin = cs.getMinValue(this.yComponentIndex.get());
        this.thumb.setTranslateX((double)(this.getXValue() - xmin) * width / (double)(xmax - xmin) - this.thumb.getWidth() * 0.5 + this.thumbTranslateX.get());
        this.thumb.setTranslateY(height - (double)(this.getYValue() - ymin) * height / (double)(ymax - ymin) - this.thumb.getHeight() * 0.5 + this.thumbTranslateY.get());
    }

    @Override
    protected @Nullable AbstractColorSlider.AbstractFillTask createFillTask(@NonNull PixelBuffer<IntBuffer> pixelBuffer) {
        if (this.getDisplayColorSpace() == null || this.getSourceColorSpace() == null || this.getTargetColorSpace() == null) {
            return null;
        }
        return new FillTask(new AbstractColorSlider.FillTaskRecord(Objects.requireNonNull(pixelBuffer), this.getSourceColorSpace(), this.getTargetColorSpace(), this.getDisplayColorSpace(), this.getC0(), this.getC1(), this.getC2(), this.getC3(), this.getXComponentIndex(), this.getYComponentIndex(), this.getAlpha(), this.getRgbFilter() == null ? i -> i : this.getRgbFilter()));
    }

    @Override
    protected void onMousePressedOrDragged(MouseEvent mouseEvent) {
        this.requestFocus();
        float width = (float)this.getWidth();
        float height = (float)this.getHeight();
        float x = MathUtil.clamp((float)((float)mouseEvent.getX()), (float)0.0f, (float)width);
        float y = MathUtil.clamp((float)((float)mouseEvent.getY()), (float)0.0f, (float)height);
        NamedColorSpace cs = this.getSourceColorSpace();
        if (cs == null) {
            return;
        }
        float xmax = cs.getMaxValue(this.xComponentIndex.get());
        float xmin = cs.getMinValue(this.xComponentIndex.get());
        float ymax = cs.getMaxValue(this.yComponentIndex.get());
        float ymin = cs.getMinValue(this.yComponentIndex.get());
        this.setXValue(this.maybeSnapToTicks(x * (xmax - xmin) / width + xmin, this.getXMinorTickUnit(), mouseEvent));
        this.setYValue(this.maybeSnapToTicks((height - y) * (ymax - ymin) / height + ymin, this.getYMinorTickUnit(), mouseEvent));
    }

    public float getXValue() {
        return this.xValue.get();
    }

    public @NonNull FloatProperty xValueProperty() {
        return this.xValue;
    }

    public void setXValue(float xValue) {
        this.xValue.set(xValue);
    }

    public float getYValue() {
        return this.yValue.get();
    }

    public @NonNull FloatProperty yValueProperty() {
        return this.yValue;
    }

    public void setYValue(float yValue) {
        this.yValue.set(yValue);
    }

    @Override
    protected void onKeyPressed(KeyEvent keyEvent) {
        NamedColorSpace cs = this.getSourceColorSpace();
        if (cs == null) {
            return;
        }
        double xTickUnit = keyEvent.isAltDown() ? this.getXMinorTickUnit() : this.getXMajorTickUnit();
        double yTickUnit = keyEvent.isAltDown() ? this.getYMinorTickUnit() : this.getYMajorTickUnit();
        float xValue = this.getXValue();
        float yValue = this.getYValue();
        double xSnappedToTick = (double)Math.round((double)xValue / xTickUnit) * xTickUnit;
        double ySnappedToTick = (double)Math.round((double)yValue / yTickUnit) * yTickUnit;
        int xIndex = this.getXComponentIndex();
        float xMin = cs.getMinValue(xIndex);
        float xMax = cs.getMaxValue(xIndex);
        int yIndex = this.getXComponentIndex();
        float yMin = cs.getMinValue(yIndex);
        float yMax = cs.getMaxValue(yIndex);
        switch (keyEvent.getCode()) {
            case UP: {
                keyEvent.consume();
                this.setYValue(MathUtil.clamp((float)((float)(ySnappedToTick + yTickUnit)), (float)yMin, (float)yMax));
                break;
            }
            case RIGHT: {
                keyEvent.consume();
                this.setXValue(MathUtil.clamp((float)((float)(xSnappedToTick + xTickUnit)), (float)xMin, (float)xMax));
                break;
            }
            case DOWN: {
                keyEvent.consume();
                this.setYValue(MathUtil.clamp((float)((float)(ySnappedToTick - yTickUnit)), (float)yMin, (float)yMax));
                break;
            }
            case LEFT: {
                keyEvent.consume();
                this.setXValue(MathUtil.clamp((float)((float)(xSnappedToTick - xTickUnit)), (float)xMin, (float)xMax));
                break;
            }
            case SPACE: {
                keyEvent.consume();
                this.setYValue(MathUtil.clamp((float)((float)ySnappedToTick), (float)yMin, (float)yMax));
                this.setXValue(MathUtil.clamp((float)((float)xSnappedToTick), (float)xMin, (float)xMax));
            }
        }
    }

    public int getXComponentIndex() {
        return this.xComponentIndex.get();
    }

    public @NonNull IntegerProperty xComponentIndexProperty() {
        return this.xComponentIndex;
    }

    public void setXComponentIndex(int xComponentIndex) {
        this.xComponentIndex.set(xComponentIndex);
    }

    public int getYComponentIndex() {
        return this.yComponentIndex.get();
    }

    public @NonNull IntegerProperty yComponentIndexProperty() {
        return this.yComponentIndex;
    }

    public void setYComponentIndex(int yComponentIndex) {
        this.yComponentIndex.set(yComponentIndex);
    }

    public double getXMinorTickUnit() {
        return this.xMinorTickUnit.get();
    }

    public @NonNull DoubleProperty xMinorTickUnitProperty() {
        return this.xMinorTickUnit;
    }

    public void setXMinorTickUnit(double xMinorTickUnit) {
        this.xMinorTickUnit.set(xMinorTickUnit);
    }

    public double getYMinorTickUnit() {
        return this.yMinorTickUnit.get();
    }

    public @NonNull DoubleProperty yMinorTickUnitProperty() {
        return this.yMinorTickUnit;
    }

    public void setYMinorTickUnit(double yMinorTickUnit) {
        this.yMinorTickUnit.set(yMinorTickUnit);
    }

    public double getXMajorTickUnit() {
        return this.xMajorTickUnit.get();
    }

    public @NonNull DoubleProperty xMajorTickUnitProperty() {
        return this.xMajorTickUnit;
    }

    public void setXMajorTickUnit(double xMajorTickUnit) {
        this.xMajorTickUnit.set(xMajorTickUnit);
    }

    public double getYMajorTickUnit() {
        return this.yMajorTickUnit.get();
    }

    public @NonNull DoubleProperty yMajorTickUnitProperty() {
        return this.yMajorTickUnit;
    }

    public void setYMajorTickUnit(double yMajorTickUnit) {
        this.yMajorTickUnit.set(yMajorTickUnit);
    }

    static class FillTask
    extends AbstractColorSlider.AbstractFillTask {
        public FillTask(@NonNull AbstractColorSlider.FillTaskRecord record) {
            super(record);
        }

        @Override
        public void accept(TileTask.Tile tile) {
            PixelBuffer<IntBuffer> pixelBuffer = this.record.pixelBuffer();
            int width = pixelBuffer.getWidth();
            int height = pixelBuffer.getHeight();
            IntBuffer b = (IntBuffer)pixelBuffer.getBuffer();
            NamedColorSpace scs = this.record.sourceColorSpace();
            NamedColorSpace tcs = this.record.targetColorSpace();
            NamedColorSpace dcs = this.record.displayColorSpace();
            int xIndex = this.record.xIndex();
            float xmin = scs.getMinValue(xIndex);
            float xmax = scs.getMaxValue(xIndex);
            int yIndex = this.record.yIndex();
            float ymin = scs.getMinValue(yIndex);
            float ymax = scs.getMaxValue(yIndex);
            float invWidth = (xmax - xmin) / (float)width;
            float invHeight = -(ymax - ymin) / (float)height;
            float[] colorValue = new float[Math.max(4, scs.getNumComponents())];
            colorValue[0] = this.record.c0();
            colorValue[1] = this.record.c1();
            colorValue[2] = this.record.c2();
            colorValue[3] = this.record.c3();
            float[] sRgb = new float[3];
            float[] tRgb = new float[3];
            float[] dRgb = new float[3];
            float[] pre = new float[3];
            float alpha = this.record.alpha();
            int[] array = b.array();
            ToIntFunction<Integer> filter = this.record.rgbFilter();
            int yfrom = tile.yfrom();
            int yto = tile.yto();
            int xfrom = tile.xfrom();
            int xto = tile.xto();
            int y = yfrom;
            int xy = yfrom * width;
            while (y < yto) {
                for (int x = xfrom; x < xto; ++x) {
                    float xval = (float)x * invWidth + xmin;
                    float yval = (float)y * invHeight + ymax;
                    colorValue[xIndex] = xval;
                    colorValue[yIndex] = yval;
                    int argb = AbstractColorSlider.getArgb(scs, tcs, dcs, colorValue, sRgb, tRgb, dRgb, pre, alpha);
                    array[x + xy] = argb = filter.applyAsInt(argb);
                }
                ++y;
                xy += width;
            }
        }
    }
}

