/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Orientation;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.color.NamedColorSpace;
import org.jhotdraw8.fxbase.binding.Via;
import org.jhotdraw8.fxcontrols.colorchooser.CheckerboardFactory;
import org.jhotdraw8.fxcontrols.colorchooser.ColorChooserPaneModel;
import org.jhotdraw8.fxcontrols.colorchooser.ColorRectangleSlider;
import org.jhotdraw8.fxcontrols.colorchooser.ColorSlider;

public class HlsChooser
extends HBox {
    private final @NonNull ObjectProperty<ColorChooserPaneModel> model = new SimpleObjectProperty((Object)this, "model");
    private final @NonNull Via<ColorChooserPaneModel> viaModel = new Via(this.model);
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private StackPane huePane;
    @FXML
    private StackPane colorRectPane;
    private ColorRectangleSlider colorRectSlider;
    private InvalidationListener colorRectSliderInvalidationListener;
    private InvalidationListener hueSliderInvalidationListener;
    private ColorSlider hueSlider;
    private ChangeListener<NamedColorSpace> targetColorSpaceListener;

    public HlsChooser() {
        this.load();
    }

    private static URL getFxml() {
        String name = "HlsChooser.fxml";
        return Objects.requireNonNull(HlsChooser.class.getResource(name), name);
    }

    private void load() {
        try {
            FXMLLoader loader = new FXMLLoader(HlsChooser.getFxml());
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.setResources(ResourceBundle.getBundle("org.jhotdraw8.fxcontrols.colorchooser.Labels"));
            loader.load();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    @FXML
    void initialize() {
        assert (this.huePane != null) : "fx:id=\"huePane\" was not injected: check your FXML file 'HlsChooser.fxml'.";
        assert (this.colorRectPane != null) : "fx:id=\"colorRectPane\" was not injected: check your FXML file 'HlsChooser.fxml'.";
        Background checkerboardBackground = new Background(new BackgroundFill[]{new BackgroundFill((Paint)CheckerboardFactory.createCheckerboardPattern(4, -1, -5592406), null, null)});
        this.colorRectPane.setBackground(checkerboardBackground);
        this.huePane.setBackground(checkerboardBackground);
        this.colorRectSlider = new ColorRectangleSlider();
        this.hueSlider = new ColorSlider();
        this.colorRectPane.getChildren().add((Object)this.colorRectSlider);
        this.huePane.getChildren().add((Object)this.hueSlider);
        this.hueSlider.setThumbTranslateX(1.0);
        this.hueSlider.setOrientation(Orientation.VERTICAL);
        this.hueSlider.c0Property().bind(this.model.flatMap(ColorChooserPaneModel::hueSliderC0Property));
        this.hueSlider.c1Property().bind(this.model.flatMap(ColorChooserPaneModel::hueSliderC1Property));
        this.hueSlider.c2Property().bind(this.model.flatMap(ColorChooserPaneModel::hueSliderC2Property));
        this.hueSlider.setMinorTickUnit(0.1);
        this.hueSlider.setMajorTickUnit(1.0);
        this.hueSlider.componentIndexProperty().bind(this.model.flatMap(ColorChooserPaneModel::sourceColorSpaceHueIndexProperty));
        this.hueSlider.sourceColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::sourceColorSpaceProperty));
        this.hueSlider.targetColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::targetColorSpaceProperty));
        this.hueSlider.displayColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayColorSpaceProperty));
        this.hueSlider.rgbFilterProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayBitDepthProperty).map(Map.Entry::getValue));
        this.colorRectSlider.c0Property().bind(this.model.flatMap(ColorChooserPaneModel::c0Property));
        this.colorRectSlider.c1Property().bind(this.model.flatMap(ColorChooserPaneModel::c1Property));
        this.colorRectSlider.c2Property().bind(this.model.flatMap(ColorChooserPaneModel::c2Property));
        this.colorRectSlider.c3Property().bind(this.model.flatMap(ColorChooserPaneModel::c3Property));
        this.colorRectSlider.alphaProperty().bind(this.model.flatMap(ColorChooserPaneModel::alphaProperty));
        this.colorRectSlider.sourceColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::sourceColorSpaceProperty));
        this.colorRectSlider.targetColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::targetColorSpaceProperty));
        this.colorRectSlider.displayColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayColorSpaceProperty));
        this.colorRectSlider.xComponentIndexProperty().bind(this.model.flatMap(ColorChooserPaneModel::sourceColorSpaceSaturationChromaIndexProperty));
        this.colorRectSlider.yComponentIndexProperty().bind(this.model.flatMap(ColorChooserPaneModel::sourceColorSpaceLightnessValueIndexProperty));
        this.colorRectSlider.rgbFilterProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayBitDepthProperty).map(Map.Entry::getValue));
        this.hueSlider.valueProperty().bindBidirectional(this.viaModel.via(ColorChooserPaneModel::hueProperty).get());
        this.colorRectSlider.xValueProperty().bindBidirectional(this.viaModel.via(ColorChooserPaneModel::chromaProperty).get());
        this.colorRectSlider.yValueProperty().bindBidirectional(this.viaModel.via(ColorChooserPaneModel::lightnessProperty).get());
        this.hueSliderInvalidationListener = o -> this.hueSlider.invalidate();
        this.viaModel.via(ColorChooserPaneModel::chooserTypeProperty).get().addListener(this.hueSliderInvalidationListener);
        this.colorRectSliderInvalidationListener = o -> this.colorRectSlider.invalidate();
        this.viaModel.via(ColorChooserPaneModel::displayBitDepthProperty).get().addListener(this.colorRectSliderInvalidationListener);
        this.viaModel.via(ColorChooserPaneModel::displayColorSpaceProperty).get().addListener(this.colorRectSliderInvalidationListener);
        this.viaModel.via(ColorChooserPaneModel::targetColorSpaceProperty).get().addListener(this.colorRectSliderInvalidationListener);
    }

    public ColorChooserPaneModel getModel() {
        return (ColorChooserPaneModel)this.model.get();
    }

    public void setModel(ColorChooserPaneModel model) {
        this.model.set((Object)model);
    }

    public @NonNull ObjectProperty<ColorChooserPaneModel> modelProperty() {
        return this.model;
    }
}

