/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.fxbase.binding.Via;
import org.jhotdraw8.fxcontrols.colorchooser.ColorChooserPaneModel;
import org.jhotdraw8.fxcontrols.colorchooser.ColorSlider;

public class SliderChooser
extends VBox {
    private final @NonNull ObjectProperty<ColorChooserPaneModel> model = new SimpleObjectProperty((Object)this, "model");
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private BorderPane c0Pane;
    private ColorSlider c0Slider;
    @FXML
    private BorderPane c1Pane;
    private ColorSlider c1Slider;
    @FXML
    private BorderPane c2Pane;
    private ColorSlider c2Slider;

    public ColorChooserPaneModel getModel() {
        return (ColorChooserPaneModel)this.model.get();
    }

    public @NonNull ObjectProperty<ColorChooserPaneModel> modelProperty() {
        return this.model;
    }

    public void setModel(ColorChooserPaneModel model) {
        this.model.set((Object)model);
    }

    public SliderChooser() {
        this.load();
    }

    private void load() {
        try {
            FXMLLoader loader = new FXMLLoader(SliderChooser.getFxml());
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.setResources(ResourceBundle.getBundle("org.jhotdraw8.fxcontrols.colorchooser.Labels"));
            loader.load();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    private static URL getFxml() {
        String name = "SliderChooser.fxml";
        return Objects.requireNonNull(SliderChooser.class.getResource(name), name);
    }

    @FXML
    void initialize() {
        assert (this.c0Pane != null) : "fx:id=\"c0Pane\" was not injected: check your FXML file 'HlsChooser.fxml'.";
        assert (this.c1Pane != null) : "fx:id=\"c1Pane\" was not injected: check your FXML file 'HlsChooser.fxml'.";
        assert (this.c2Pane != null) : "fx:id=\"c2Pane\" was not injected: check your FXML file 'HlsChooser.fxml'.";
        this.c0Slider = new ColorSlider();
        this.c0Pane.setCenter((Node)this.c0Slider);
        this.c1Slider = new ColorSlider();
        this.c1Pane.setCenter((Node)this.c1Slider);
        this.c2Slider = new ColorSlider();
        this.c2Pane.setCenter((Node)this.c2Slider);
        this.c0Slider.setComponentIndex(0);
        this.c1Slider.setComponentIndex(1);
        this.c2Slider.setComponentIndex(2);
        this.c0Slider.c1Property().bind(this.model.flatMap(ColorChooserPaneModel::c1Property));
        this.c0Slider.c2Property().bind(this.model.flatMap(ColorChooserPaneModel::c2Property));
        this.c0Slider.c3Property().bind(this.model.flatMap(ColorChooserPaneModel::c3Property));
        this.c0Slider.targetColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::targetColorSpaceProperty));
        this.c0Slider.displayColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayColorSpaceProperty));
        this.c0Slider.rgbFilterProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayBitDepthProperty).map(Map.Entry::getValue));
        this.c1Slider.c0Property().bind(this.model.flatMap(ColorChooserPaneModel::c0Property));
        this.c1Slider.c2Property().bind(this.model.flatMap(ColorChooserPaneModel::c2Property));
        this.c1Slider.c3Property().bind(this.model.flatMap(ColorChooserPaneModel::c3Property));
        this.c1Slider.targetColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::targetColorSpaceProperty));
        this.c1Slider.displayColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayColorSpaceProperty));
        this.c1Slider.rgbFilterProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayBitDepthProperty).map(Map.Entry::getValue));
        this.c2Slider.c0Property().bind(this.model.flatMap(ColorChooserPaneModel::c0Property));
        this.c2Slider.c1Property().bind(this.model.flatMap(ColorChooserPaneModel::c1Property));
        this.c2Slider.c3Property().bind(this.model.flatMap(ColorChooserPaneModel::c3Property));
        this.c2Slider.targetColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::targetColorSpaceProperty));
        this.c2Slider.displayColorSpaceProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayColorSpaceProperty));
        this.c2Slider.rgbFilterProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayBitDepthProperty).map(Map.Entry::getValue));
        this.c0Slider.c0Property().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::c0Property).get());
        this.c1Slider.c1Property().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::c1Property).get());
        this.c2Slider.c2Property().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::c2Property).get());
    }
}

