/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.dock;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Region;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.fxcontrols.dock.DockChild;
import org.jhotdraw8.fxcontrols.dock.DockParent;

public abstract class AbstractDockParent
extends Region
implements DockParent {
    protected final BooleanProperty showing = new SimpleBooleanProperty((Object)this, "showing");
    protected final BooleanProperty editable = new SimpleBooleanProperty((Object)this, "editable", true);
    protected final ObjectProperty<DockParent> dockParent = new SimpleObjectProperty((Object)this, "dockParent");
    protected final ObservableList<DockChild> dockChildren = FXCollections.observableArrayList();

    public AbstractDockParent() {
        this.dockChildren.addListener(change -> {
            while (change.next()) {
                for (DockChild removed : change.getRemoved()) {
                    removed.setDockParent(null);
                }
                for (DockChild added : change.getAddedSubList()) {
                    if (added.getDockParent() != null) {
                        added.getDockParent().getDockChildren().remove((Object)added);
                    }
                    added.setDockParent(this);
                }
            }
        });
    }

    @Override
    public @NonNull ObjectProperty<DockParent> dockParentProperty() {
        return this.dockParent;
    }

    @Override
    public @NonNull ObservableList<DockChild> getDockChildren() {
        return this.dockChildren;
    }

    public @NonNull Parent getNode() {
        return this;
    }

    @Override
    public @NonNull BooleanProperty showingProperty() {
        return this.showing;
    }

    @Override
    public @NonNull BooleanProperty editableProperty() {
        return this.editable;
    }

    protected void layoutChildren() {
        List managed = this.getManagedChildren();
        double width = this.getWidth();
        double height = this.getHeight();
        Insets insets = this.getInsets();
        double top = insets.getTop();
        double right = insets.getRight();
        double left = insets.getLeft();
        double bottom = insets.getBottom();
        double contentWidth = width - left - right;
        double contentHeight = height - top - bottom;
        double baselineOffset = 0.0;
        HPos alignHpos = HPos.LEFT;
        VPos alignVpos = VPos.TOP;
        for (Node child : managed) {
            this.layoutInArea(child, left, top, contentWidth, contentHeight, baselineOffset, null, alignHpos, alignVpos);
        }
    }
}

