/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.dock;

import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxcontrols.dock.DockRoot;
import org.jhotdraw8.fxcontrols.dock.Dockable;

class DockableDragHandler {
    private final Dockable dockable;
    private final ChangeListener<Node> graphicChangedListener = this::onGraphicChanged;

    public DockableDragHandler(Dockable dockable) {
        this.dockable = dockable;
        dockable.graphicProperty().addListener(this.graphicChangedListener);
        this.onGraphicChanged((Observable)dockable.graphicProperty(), null, dockable.getGraphic());
    }

    private void onGraphicChanged(Observable o, @Nullable Node oldv, @Nullable Node newv) {
        if (oldv != null) {
            oldv.setOnDragDetected(null);
            oldv.setOnDragDone(null);
        }
        if (newv != null) {
            newv.setOnDragDetected(this::onDragDetected);
            newv.setOnDragDone(this::onDragDone);
        }
    }

    private void onDragDone(DragEvent e) {
        DockRoot.setDraggedDockable(null);
    }

    private void onDragDetected(@NonNull MouseEvent e) {
        if (this.dockable.getDockRoot() == null) {
            return;
        }
        Node graphic = this.dockable.getGraphic();
        DockRoot.setDraggedDockable(this.dockable);
        Dragboard db = graphic.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        db.setDragView((Image)(graphic.getParent() == null ? graphic : graphic.getParent()).snapshot(null, null), e.getX(), e.getY());
        ClipboardContent content = new ClipboardContent();
        content.put((Object)DockRoot.DOCKABLE_DATA_FORMAT, (Object)System.identityHashCode(this));
        db.setContent((Map)content);
        e.consume();
    }

    public void dispose() {
        this.dockable.graphicProperty().removeListener(this.graphicChangedListener);
        Node oldv = this.dockable.getGraphic();
        if (oldv != null) {
            oldv.setOnDragDetected(null);
            oldv.setOnDragDone(null);
        }
    }
}

