/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.dock;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import org.jhotdraw8.annotation.NonNull;

public class ResizeButton
extends Region {
    private Point2D pressed;
    private Point2D size;
    private final ObjectProperty<Region> target = new SimpleObjectProperty();

    public ResizeButton() {
        this.setOnMousePressed(this::mousePressed);
        this.setOnMouseDragged(this::mouseDragged);
        this.setCursor(Cursor.V_RESIZE);
        this.setMinHeight(1.0);
        this.setMinWidth(1.0);
    }

    public Region getTarget() {
        return (Region)this.target.get();
    }

    public void setTarget(Region value) {
        this.target.set((Object)value);
    }

    private void mouseDragged(@NonNull MouseEvent evt) {
        Region t = this.getTarget();
        if (t != null && this.pressed != null) {
            Point2D current = new Point2D(evt.getSceneX(), evt.getSceneY());
            Point2D delta = current.subtract(this.pressed);
            t.setPrefWidth(this.size.getX() + delta.getX());
            t.setPrefHeight(this.size.getY() + delta.getY());
        }
    }

    private void mousePressed(@NonNull MouseEvent evt) {
        Region t = this.getTarget();
        if (t != null) {
            this.pressed = new Point2D(evt.getSceneX(), evt.getSceneY());
            this.size = new Point2D(this.getTarget().getWidth(), t.getHeight());
        }
    }

    public @NonNull ObjectProperty<Region> targetProperty() {
        return this.target;
    }
}

